/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class SortSpec
implements ASTNode {
    private static final long serialVersionUID = -8115669253085961836L;
    private ValueExpression sortKey;
    private SortType type;
    private NullOrderingSpec nullOrderingSpec;

    public SortSpec() {
    }

    public SortSpec(String sortKeyField, SortType type) {
        this.sortKey = new EntityField(sortKeyField);
        this.type = type;
    }

    public SortSpec(ValueExpression sortKey, SortType type) {
        this.sortKey = sortKey;
        this.type = type;
    }

    public SortSpec(ValueExpression sortKey, SortType type, NullOrderingSpec nullOrderingSpec) {
        this.sortKey = sortKey;
        this.type = type;
        this.nullOrderingSpec = nullOrderingSpec;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(QueryVisitor visitor) {
        if (visitor.visit(this)) {
            this.sortKey.accept(visitor);
        }
    }

    public ValueExpression getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(ValueExpression sortKey) {
        this.sortKey = sortKey;
    }

    public SortType getType() {
        return this.type;
    }

    public void setType(SortType type) {
        this.type = type;
    }

    public NullOrderingSpec getNullOrderingSpec() {
        return this.nullOrderingSpec;
    }

    public void setNullOrderingSpec(NullOrderingSpec nullOrderingSpec) {
        this.nullOrderingSpec = nullOrderingSpec;
    }

    public SortSpec nulls(NullOrderingSpec nullOrderingSpec) {
        this.nullOrderingSpec = nullOrderingSpec;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sortKey);
        if (this.type != null) {
            sb.append(" ");
            sb.append((Object)this.type);
        }
        if (this.nullOrderingSpec != null) {
            sb.append(" NULLS ");
            sb.append((Object)this.nullOrderingSpec);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nullOrderingSpec == null ? 0 : this.nullOrderingSpec.hashCode());
        result = 31 * result + (this.sortKey == null ? 0 : this.sortKey.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortSpec other = (SortSpec)obj;
        if (this.nullOrderingSpec != other.nullOrderingSpec) {
            return false;
        }
        if (this.sortKey == null ? other.sortKey != null : !this.sortKey.equals(other.sortKey)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum NullOrderingSpec {
        FIRST,
        LAST;

    }

    public static enum SortType {
        ASC,
        DESC;

    }
}

