/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class SubQuery
implements ASTNode {
    private static final long serialVersionUID = -5969806128437230832L;
    public static final String THIS = "this";
    private Query query;
    private Condition on;

    public SubQuery() {
    }

    public SubQuery(Query query) {
        this.query = query;
    }

    public SubQuery(Query query, Condition on) {
        this.query = query;
        this.on = on;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public Condition getOn() {
        return this.on;
    }

    public void setOn(Condition on) {
        this.on = on;
    }

    public SubQuery on(Condition on) {
        this.setOn(on);
        return this;
    }

    public SubQuery on(EntityField mainQueryProperty, EntityField subQueryProperty, int unnestCount) {
        this.on = new Equals(this.withDot(mainQueryProperty, unnestCount), subQueryProperty);
        return this;
    }

    private EntityField withDot(EntityField propName, int unnestCount) {
        if (propName == null || propName.getPropertyName() == null) {
            propName = new EntityField(THIS);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unnestCount; ++i) {
            sb.append('.');
        }
        sb.append(propName.getPropertyName());
        return new EntityField(sb.toString());
    }

    public SubQuery on(String mainQueryProperyName, String subQueryPropertyName, int unnestCount) {
        return this.on(new EntityField(mainQueryProperyName), new EntityField(subQueryPropertyName), unnestCount);
    }

    public SubQuery on(String mainQueryProperyName, String subQueryPropertyName) {
        return this.on(mainQueryProperyName, subQueryPropertyName, 1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.query);
        if (this.on != null) {
            sb.append(" on ");
            sb.append(this.on);
        }
        sb.append(")");
        return sb.toString();
    }

    public void accept(QueryVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor instanceof QueryVisitor && this.query != null) {
                this.query.accept(visitor);
            }
            if (this.on != null && visitor instanceof ConditionVisitor) {
                this.on.accept(visitor);
            }
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubQuery other = (SubQuery)obj;
        if (this.on == null ? other.on != null : !this.on.equals(other.on)) {
            return false;
        }
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }
}

