/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.condition.predicate;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;

public class In
extends Predicate {
    private static final long serialVersionUID = -3174824555455261230L;
    private List<ValueExpression> propertyList;
    private List<ValueExpression> value;
    private SubQuery subQuery;

    public In() {
    }

    public In(String propertyName, Object ... literalValues) {
        this.setPropertyName(propertyName);
        ArrayList<ValueExpression> valList = new ArrayList<ValueExpression>();
        if (literalValues != null) {
            for (Object o : literalValues) {
                if (o instanceof Literal) {
                    valList.add((Literal)o);
                    continue;
                }
                valList.add(new Literal(o));
            }
        }
        this.value = valList;
    }

    public In(String[] propertyName, Object[] ... literalRowValueLists) {
        this.setPropertyName(propertyName);
        ArrayList<ValueExpression> valList = new ArrayList<ValueExpression>();
        if (literalRowValueLists != null) {
            for (Object[] o : literalRowValueLists) {
                RowValueList rvl = new RowValueList(o);
                valList.add(rvl);
            }
        }
        this.value = valList;
    }

    public In(String propertyName, SubQuery subQuery) {
        this.setPropertyName(propertyName);
        this.subQuery = subQuery;
    }

    public In(String[] propertyName, SubQuery subQuery) {
        this.setPropertyName(propertyName);
        this.subQuery = subQuery;
    }

    public In(String propertyName, Query subQuery) {
        this.setPropertyName(propertyName);
        this.subQuery = new SubQuery(subQuery);
    }

    public In(String[] propertyName, Query subQuery) {
        this.setPropertyName(propertyName);
        this.subQuery = new SubQuery(subQuery);
    }

    public In(String[] propertyName, List<ValueExpression> value) {
        this.setPropertyName(propertyName);
        this.value = value;
    }

    public In(ValueExpression property, List<ValueExpression> value) {
        this.setProperty(property);
        this.value = value;
    }

    public In(ValueExpression property, Object ... literalValues) {
        this.setProperty(property);
        ArrayList<ValueExpression> valList = new ArrayList<ValueExpression>();
        if (literalValues != null) {
            for (Object o : literalValues) {
                if (o instanceof Literal) {
                    valList.add((Literal)o);
                    continue;
                }
                valList.add(new Literal(o));
            }
        }
        this.value = valList;
    }

    public In(ValueExpression property, SubQuery subQuery) {
        this.setProperty(property);
        this.subQuery = subQuery;
    }

    public In(List<ValueExpression> property, SubQuery subQuery) {
        this.setPropertyList(property);
        this.subQuery = subQuery;
    }

    public In(ValueExpression property, Query subQuery) {
        this.setProperty(property);
        this.subQuery = new SubQuery(subQuery);
    }

    public In(List<ValueExpression> property, Query subQuery) {
        this.setPropertyList(property);
        this.subQuery = new SubQuery(subQuery);
    }

    public In(List<ValueExpression> property, List<ValueExpression> value) {
        this.setPropertyList(property);
        this.value = value;
    }

    public void setPropertyName(String ... propertyName) {
        this.propertyList = new ArrayList<ValueExpression>();
        for (String pName : propertyName) {
            this.propertyList.add(new EntityField(pName));
        }
    }

    public void setProperty(ValueExpression ... property) {
        this.propertyList = new ArrayList<ValueExpression>();
        for (ValueExpression p : property) {
            this.propertyList.add(p);
        }
    }

    public void setPropertyList(List<ValueExpression> propertyList) {
        this.propertyList = propertyList;
    }

    public List<ValueExpression> getPropertyList() {
        return this.propertyList;
    }

    public List<ValueExpression> getValue() {
        return this.value;
    }

    public void setValue(List<ValueExpression> value) {
        this.value = value;
    }

    public SubQuery getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(SubQuery subQuery) {
        this.subQuery = subQuery;
    }

    @Override
    public void accept(ConditionVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor instanceof ValueExpressionVisitor) {
                ValueExpressionVisitor vVisitor = (ValueExpressionVisitor)((Object)visitor);
                if (this.propertyList != null) {
                    for (ValueExpression p : this.propertyList) {
                        p.accept(vVisitor);
                    }
                }
                if (this.value != null) {
                    for (ValueExpression v : this.value) {
                        v.accept(vVisitor);
                    }
                }
            }
            if (visitor instanceof QueryVisitor && this.subQuery != null) {
                this.subQuery.accept((QueryVisitor)visitor);
            }
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.propertyList == null) {
            sb.append("null");
        } else if (this.propertyList.size() == 1) {
            sb.append(this.propertyList.get(0));
        } else {
            sb.append("(");
            for (i = 0; i < this.propertyList.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.propertyList.get(i));
            }
            sb.append(")");
        }
        sb.append(" in ");
        if (this.subQuery != null) {
            sb.append(this.subQuery.toString());
        } else {
            sb.append("(");
            if (this.value != null) {
                for (i = 0; i < this.value.size(); ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(this.value.get(i));
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyList == null ? 0 : this.propertyList.hashCode());
        result = 31 * result + (this.subQuery == null ? 0 : this.subQuery.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        In other = (In)obj;
        if (this.propertyList == null ? other.propertyList != null : !this.propertyList.equals(other.propertyList)) {
            return false;
        }
        if (this.subQuery == null ? other.subQuery != null : !this.subQuery.equals(other.subQuery)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

