/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.Literal;

public class RowValueList
extends ValueExpression {
    private static final long serialVersionUID = -7414534715211409579L;
    private List<ValueExpression> rowValues;

    public RowValueList() {
    }

    public RowValueList(List<ValueExpression> rowValues) {
        this.rowValues = rowValues;
    }

    public RowValueList(ValueExpression ... rowValue) {
        if (rowValue != null) {
            this.rowValues = new ArrayList<ValueExpression>();
            for (ValueExpression v : rowValue) {
                this.rowValues.add(v);
            }
        }
    }

    public RowValueList(Object ... literalRowValue) {
        if (literalRowValue != null) {
            this.rowValues = new ArrayList<ValueExpression>();
            for (Object o : literalRowValue) {
                if (o instanceof Literal) {
                    this.rowValues.add((ValueExpression)o);
                    continue;
                }
                this.rowValues.add(new Literal(o));
            }
        }
    }

    public List<ValueExpression> getRowValues() {
        return this.rowValues;
    }

    public void setRowValues(List<ValueExpression> rowValues) {
        this.rowValues = rowValues;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.rowValues != null) {
            for (ValueExpression v : this.rowValues) {
                v.accept(visitor);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rowValues == null ? 0 : this.rowValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowValueList other = (RowValueList)obj;
        return !(this.rowValues == null ? other.rowValues != null : !this.rowValues.equals(other.rowValues));
    }

    @Override
    public String toString() {
        if (this.rowValues == null) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.rowValues.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.rowValues.get(i));
        }
        sb.append(")");
        return sb.toString();
    }
}

