/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.primary;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;

public class Cast
extends PrimaryValue {
    private static final long serialVersionUID = 2416190287903177109L;
    private ValueExpression value;
    private PropertyDefinitionType type;
    private List<Integer> typeArguments;

    public Cast() {
    }

    public Cast(ValueExpression value, PropertyDefinitionType type) {
        this.value = value;
        this.type = type;
    }

    public Cast(ValueExpression value, PropertyDefinitionType type, List<Integer> typeArguments) {
        this.value = value;
        this.type = type;
        this.typeArguments = typeArguments;
    }

    public Cast(ValueExpression value, PropertyDefinitionType type, Integer ... typeArgs) {
        this.value = value;
        this.type = type;
        if (typeArgs != null && typeArgs.length > 0) {
            this.typeArguments = new ArrayList<Integer>(typeArgs.length);
            for (Integer i : typeArgs) {
                this.typeArguments.add(i);
            }
        }
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public PropertyDefinitionType getType() {
        return this.type;
    }

    public void setType(PropertyDefinitionType type) {
        this.type = type;
    }

    public List<Integer> getTypeArguments() {
        return this.typeArguments;
    }

    public void setTypeArguments(List<Integer> typeArguments) {
        this.typeArguments = typeArguments;
    }

    public Integer getTypeArgument(int index) {
        if (this.typeArguments == null) {
            return null;
        }
        if (this.typeArguments.size() <= index) {
            return null;
        }
        return this.typeArguments.get(index);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cast(");
        sb.append(this.value);
        sb.append(" as ");
        sb.append((Object)this.type);
        if (this.typeArguments != null && this.typeArguments.size() > 0) {
            sb.append("(");
            boolean first = true;
            for (Integer ta : this.typeArguments) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(ta);
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.typeArguments == null ? 0 : this.typeArguments.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cast other = (Cast)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.typeArguments == null ? other.typeArguments != null : !this.typeArguments.equals(other.typeArguments)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.value != null) {
            this.value.accept(visitor);
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }
}

