/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.iplass.mtp.async.AsyncTaskFuture;
import org.iplass.mtp.async.AsyncTaskInfo;
import org.iplass.mtp.async.AsyncTaskInfoSearchCondtion;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.async.AsyncTaskOption;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.async.rdb.Queue;
import org.iplass.mtp.impl.async.rdb.RdbAsyncTaskService;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.async.rdb.TaskSearchCondition;
import org.iplass.mtp.impl.async.thread.ThreadingAsyncTaskService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;

public class AsyncTaskManagerImpl
implements AsyncTaskManager {
    private ThreadingAsyncTaskService localThreadService;
    private AsyncTaskService queueService;

    public AsyncTaskManagerImpl() {
        ServiceRegistry sr = ServiceRegistry.getRegistry();
        this.localThreadService = (ThreadingAsyncTaskService)sr.getService(AsyncTaskService.class);
        this.queueService = (AsyncTaskService)sr.getService("DefaultQueueBaseAsyncTaskService");
    }

    @Override
    public <V> Future<V> executeOnThread(Callable<V> task) {
        return this.localThreadService.execute(task);
    }

    @Override
    public <V> AsyncTaskFuture<V> execute(Callable<V> task) {
        return this.execute(new AsyncTaskOption(), task);
    }

    @Override
    public <V> AsyncTaskFuture<V> execute(AsyncTaskOption option, Callable<V> task) {
        if (option.getQueue() != null && option.getQueue().equals("localThread")) {
            return this.localThreadService.execute(task, option, true);
        }
        return this.queueService.execute(task, option, true);
    }

    @Override
    public <V> AsyncTaskFuture<V> getResult(long taskId, String queueName) {
        return this.queueService.getResult(taskId, queueName);
    }

    @Override
    public AsyncTaskInfo loadAsyncTaskInfo(long taskId, String queueName) {
        Queue q = this.getQueue(queueName);
        Task task = q.peek(taskId, true, true);
        if (task == null) {
            return null;
        }
        return this.toInfo(q.getName(), task);
    }

    private AsyncTaskInfo toInfo(String queueName, Task task) {
        AsyncTaskInfo info = new AsyncTaskInfo();
        info.setQueue(queueName);
        info.setTaskId(task.getTaskId());
        info.setGroupingKey(task.getGroupingKey());
        info.setStatus(task.getStatus());
        info.setRetryCount(task.getRetryCount());
        info.setExceptionHandlingMode(task.getExceptionHandlingMode());
        info.setReturnResult(task.isReturnResult());
        if (task.getCallable() != null) {
            info.setTask(task.getCallable().getActual());
        }
        info.setResult(task.getResult());
        return info;
    }

    private Queue getQueue(String queueName) {
        if (queueName == null) {
            queueName = "default";
        }
        if (queueName.equals("localThread")) {
            return null;
        }
        Queue q = ((RdbAsyncTaskService)this.queueService).getQueueService().getQueue(queueName);
        if (q == null) {
            throw new IllegalArgumentException("queue:" + queueName + " is not defined.");
        }
        return q;
    }

    @Override
    public List<AsyncTaskInfo> searchAsyncTaskInfo(AsyncTaskInfoSearchCondtion cond) {
        Queue q = this.getQueue(cond.getQueue());
        TaskSearchCondition tsc = new TaskSearchCondition();
        tsc.setTenantId(ExecuteContext.getCurrentContext().getClientTenantId());
        tsc.setQueueId(q.getConfig().getId());
        tsc.setTaskId(cond.getTaskId());
        tsc.setStatus(cond.getStatus());
        tsc.setWithHistory(cond.isWithHistory());
        tsc.setGroupingKey(cond.getGroupingKey());
        tsc.setRetryCount(cond.getRetryCount());
        tsc.setReturnResult(cond.getReturnResult());
        tsc.setLimit(cond.getLimit());
        tsc.setOffset(cond.getOffset());
        List<Task> taskList = q.search(tsc);
        ArrayList<AsyncTaskInfo> result = new ArrayList<AsyncTaskInfo>(taskList.size());
        for (Task t : taskList) {
            result.add(this.toInfo(q.getName(), t));
        }
        return result;
    }

    @Override
    public void forceDelete(long taskId, String queueName) {
        Queue q = this.getQueue(queueName);
        if (q != null) {
            q.forceDelete(taskId);
        }
    }
}

