/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfoList;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.ServiceRegistry;

public class AuthTokenInfoListImpl
implements AuthTokenInfoList {
    private UserContext userContext;
    private AuthTokenService tokenService;

    public AuthTokenInfoListImpl(UserContext userContext) {
        this.userContext = userContext;
        this.tokenService = ServiceRegistry.getRegistry().getService(AuthTokenService.class);
    }

    @Override
    public List<AuthTokenInfo> getList() {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String userUniqueKey = this.userContext.getAccount().getUnmodifiableUniqueKey();
        ArrayList<AuthTokenInfo> atiList = new ArrayList<AuthTokenInfo>();
        for (AuthTokenStore s : this.tokenService.getStores()) {
            List<AuthToken> sList = s.getByOwner(tenantId, userUniqueKey);
            if (sList == null) continue;
            for (AuthToken at : sList) {
                AuthTokenHandler handler = this.tokenService.getHandler(at.getType());
                if (handler == null || !handler.isVisible()) continue;
                atiList.add(handler.toAuthTokenInfo(at));
            }
        }
        return atiList;
    }

    @Override
    public AuthTokenInfo get(String type, String key) {
        AuthTokenHandler handler = this.tokenService.getHandler(type);
        if (handler == null) {
            return null;
        }
        if (!handler.isVisible()) {
            return null;
        }
        AuthToken t = handler.authTokenStore().getBySeries(ExecuteContext.getCurrentContext().getClientTenantId(), type, key);
        return handler.toAuthTokenInfo(t);
    }

    @Override
    public void remove(String type, String key) {
        AuthTokenHandler handler = this.tokenService.getHandler(type);
        if (handler != null && handler.isVisible()) {
            handler.authTokenStore().deleteBySeries(ExecuteContext.getCurrentContext().getClientTenantId(), type, key);
        }
    }

    @Override
    public Credential generateNewToken(AuthTokenInfo newTokenInfo) {
        AuthTokenHandler handler = this.tokenService.getHandler(newTokenInfo.getType());
        if (handler == null) {
            throw new IllegalArgumentException("type:" + newTokenInfo.getType() + " undefined.");
        }
        if (!handler.isVisible()) {
            throw new IllegalArgumentException("type:" + newTokenInfo.getType() + " is invisible.");
        }
        AuthToken newToken = handler.newAuthToken(this.userContext.getAccount().getUnmodifiableUniqueKey(), this.userContext.getUser().getAccountPolicy(), newTokenInfo);
        handler.authTokenStore().create(newToken);
        return handler.toCredential(newToken);
    }
}

