/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.log.AuthLogger;
import org.iplass.mtp.impl.auth.log.AuthLoggerService;
import org.iplass.mtp.spi.ServiceRegistry;

public class LoggingAccountManagementModule
implements AccountManagementModule {
    private AccountManagementModule amm;
    private AuthLogger authLogger = ServiceRegistry.getRegistry().getService(AuthLoggerService.class).getAuthLogger(null);

    public LoggingAccountManagementModule(AccountManagementModule amm) {
        this.amm = amm;
    }

    @Override
    public boolean canCreate() {
        return this.amm.canCreate();
    }

    @Override
    public boolean canUpdate() {
        return this.amm.canUpdate();
    }

    @Override
    public boolean canRemove() {
        return this.amm.canRemove();
    }

    @Override
    public boolean canRestore() {
        return this.amm.canRestore();
    }

    @Override
    public boolean canPurge() {
        return this.amm.canPurge();
    }

    @Override
    public boolean canUpdateCredential() {
        return this.amm.canUpdateCredential();
    }

    @Override
    public boolean canResetCredential() {
        return this.amm.canResetCredential();
    }

    @Override
    public void create(User user) {
        this.amm.create(user);
    }

    @Override
    public void afterCreate(User user) {
        this.amm.afterCreate(user);
    }

    @Override
    public void update(User user, List<String> updateProperties) {
        this.amm.update(user, updateProperties);
    }

    @Override
    public void remove(User user) {
        this.amm.remove(user);
    }

    @Override
    public void restore(User user) {
        this.amm.restore(user);
    }

    @Override
    public void purge(User user) {
        this.amm.purge(user);
    }

    @Override
    public void updateCredential(Credential oldCredential, Credential newCredential) throws CredentialUpdateException {
        try {
            this.amm.updateCredential(oldCredential, newCredential);
            this.authLogger.updatePasswordSuccess(oldCredential);
        }
        catch (CredentialUpdateException e) {
            this.authLogger.updatePasswordFail(oldCredential, e);
            throw e;
        }
    }

    @Override
    public void resetCredential(Credential credential) throws CredentialUpdateException {
        this.amm.resetCredential(credential);
        this.authLogger.resetPasswordSuccess(credential);
    }

    @Override
    public boolean canResetLockoutStatus() {
        return this.amm.canResetLockoutStatus();
    }

    @Override
    public void resetLockoutStatus(String accountId) {
        this.amm.resetLockoutStatus(accountId);
    }
}

