/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.HashSet;
import java.util.Map;
import org.iplass.mtp.auth.Group;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;

public class UserContextImpl
implements UserContext {
    private static final long serialVersionUID = 8750752179647454737L;
    private AccountHandle account;
    private User userEntity;
    private String[] groupCode;

    public UserContextImpl(AccountHandle account, User userEntity) {
        Object groupCode;
        Map<String, Object> accountAttributes;
        Group[] group;
        this.account = account;
        this.userEntity = userEntity;
        HashSet<Object> list = new HashSet<Object>();
        if (userEntity != null && (group = userEntity.getGroups()) != null) {
            for (Group g : group) {
                list.add(g.getValue("code"));
            }
        }
        if ((accountAttributes = account.getAttributeMap()) != null && (groupCode = accountAttributes.get("groupCode")) != null) {
            if (groupCode instanceof String) {
                if (((String)groupCode).indexOf(44) >= 0) {
                    String[] gcs;
                    for (String gc : gcs = ((String)groupCode).split(",")) {
                        String gctrimed = gc.trim();
                        if (gctrimed.isEmpty()) continue;
                        list.add(gctrimed);
                    }
                } else {
                    list.add((String)groupCode);
                }
            } else if (groupCode instanceof String[]) {
                String[] gCodeList;
                for (String g : gCodeList = (String[])groupCode) {
                    list.add(g);
                }
            } else {
                throw new IllegalStateException("groupCode supports String/String[] types");
            }
        }
        if (list.size() != 0) {
            this.groupCode = list.toArray(new String[list.size()]);
        }
    }

    @Override
    public User getUser() {
        return this.userEntity;
    }

    @Override
    public AccountHandle getAccount() {
        return this.account;
    }

    @Override
    public Object getAttribute(String name) {
        Map<String, Object> accountAttributeMap;
        Object val = null;
        if (this.userEntity != null) {
            val = this.userEntity.getValue(name);
        }
        if (val == null && (accountAttributeMap = this.account.getAttributeMap()) != null) {
            val = accountAttributeMap.get(name);
        }
        return val;
    }

    @Override
    public String[] getGroupCode() {
        if (this.groupCode == null) {
            return null;
        }
        String[] copy = new String[this.groupCode.length];
        System.arraycopy(this.groupCode, 0, copy, 0, this.groupCode.length);
        return copy;
    }

    @Override
    public String getIdForLog() {
        if (this.userEntity == null) {
            return this.account.getCredential().getId();
        }
        return this.userEntity.getOid();
    }

    @Override
    public void resetUserEntity(User userEntity) {
        this.userEntity = userEntity;
    }
}

