/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate;

import java.util.Map;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;

public final class AnonymousUserContext
implements UserContext {
    private static final long serialVersionUID = 6503268584220120432L;
    private static final User anonymousUser;
    private static final AccountHandle anonymousAccount;

    @Override
    public User getUser() {
        return anonymousUser;
    }

    @Override
    public AccountHandle getAccount() {
        return anonymousAccount;
    }

    @Override
    public Object getAttribute(String name) {
        return anonymousUser.getValue(name);
    }

    @Override
    public String[] getGroupCode() {
        return null;
    }

    @Override
    public String getIdForLog() {
        return "Anonymous";
    }

    @Override
    public void resetUserEntity(User userEntity) {
    }

    static {
        anonymousAccount = new AccountHandle(){
            private static final long serialVersionUID = 6431803480686097702L;

            @Override
            public boolean isExpired() {
                return false;
            }

            @Override
            public boolean isAccountLocked() {
                return false;
            }

            @Override
            public boolean isInitialLogin() {
                return false;
            }

            @Override
            public Credential getCredential() {
                return new Credential(){

                    @Override
                    public String getId() {
                        return "Anonymous";
                    }

                    @Override
                    public Object getAuthenticationFactor(String name) {
                        return null;
                    }

                    @Override
                    public void setAuthenticationFactor(String name, Object value) {
                    }
                };
            }

            @Override
            public Map<String, Object> getAttributeMap() {
                return null;
            }

            @Override
            public void setAuthenticationProviderIndex(int authenticationProviderIndex) {
            }

            @Override
            public int getAuthenticationProviderIndex() {
                return 0;
            }

            @Override
            public String getUnmodifiableUniqueKey() {
                return null;
            }
        };
        anonymousUser = new User("Anonymous", "Anonymous", true);
    }
}

