/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.configfile;

import java.util.List;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.configfile.AccountConfig;
import org.iplass.mtp.impl.auth.authenticate.configfile.ConfigFileAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.configfile.ConfigFileUserEntityResolver;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.Config;

public class ConfigFileAuthenticationProvider
extends AuthenticationProviderBase {
    private List<AccountConfig> accounts;
    private List<Integer> tenantIds;

    public List<AccountConfig> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountConfig> accounts) {
        this.accounts = accounts;
    }

    public List<Integer> getTenantIds() {
        return this.tenantIds;
    }

    public void setTenantIds(List<Integer> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    public void inited(AuthService service, Config config) {
        if (this.getUserEntityResolver() == null) {
            ConfigFileUserEntityResolver uer = new ConfigFileUserEntityResolver();
            uer.inited(service, this);
            this.setUserEntityResolver(uer);
        }
        super.inited(service, config);
    }

    @Override
    public AccountHandle login(Credential credential) {
        if (!(credential instanceof IdPasswordCredential)) {
            return null;
        }
        if (this.tenantIds != null && this.tenantIds.size() > 0) {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            boolean ok = false;
            for (Integer tid : this.tenantIds) {
                if (tid != tenantId) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
        }
        IdPasswordCredential idPass = (IdPasswordCredential)credential;
        if (this.accounts != null) {
            for (AccountConfig ac : this.accounts) {
                if (!ac.getId().equals(idPass.getId()) || !ac.getPassword().equals(idPass.getPassword())) continue;
                return new ConfigFileAccountHandle(ac);
            }
        }
        return null;
    }

    @Override
    public void logout(AccountHandle user) {
    }

    @Override
    public AccountManagementModule getAccountManagementModule() {
        return AuthenticationProviderBase.NO_UPDATABLE_AMM;
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return IdPasswordCredential.class;
    }

    @Override
    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return ConfigFileAccountHandle.class;
    }

    @Override
    public boolean isSelectableOnAuthPolicy() {
        return false;
    }
}

