/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.cache.CacheController;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.LoadingAdapter;
import org.iplass.mtp.impl.cache.store.keyresolver.CacheKeyResolver;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionStatus;

public class CachableAuthTokenStore
implements AuthTokenStore,
ServiceInitListener<AuthTokenService> {
    private static final String DEFAULT_TOKEN_CACHE_NAMESPACE = "mtp.auth.cachableAuthTokenStore/DEFAULT";
    private String cacheStoreName = "mtp.auth.cachableAuthTokenStore/DEFAULT";
    private AuthTokenStore authTokenStore;
    private CacheController<AuthTokenKey, AuthToken> tokenCache;

    @Override
    public void inited(AuthTokenService service, Config config) {
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        this.tokenCache = new CacheController<AuthTokenKey, AuthToken>(cs.getCache(this.cacheStoreName), false, 0, new LoadingAdapter<AuthTokenKey, AuthToken>(){

            @Override
            public AuthToken load(AuthTokenKey key) {
                return CachableAuthTokenStore.this.authTokenStore.getBySeries(key.getTenantId(), key.getType(), key.getSeries());
            }

            @Override
            public List<AuthToken> loadByIndex(int indexType, Object indexVal) {
                return null;
            }

            @Override
            public long getVersion(AuthToken value) {
                return 0L;
            }

            @Override
            public Object getIndexVal(int indexType, AuthToken value) {
                return null;
            }

            @Override
            public AuthTokenKey getKey(AuthToken val) {
                return new AuthTokenKey(val.getTenantId(), val.getType(), val.getSeries());
            }
        }, true, false);
    }

    @Override
    public void destroyed() {
    }

    public String getCacheStoreName() {
        return this.cacheStoreName;
    }

    public void setCacheStoreName(String cacheStoreName) {
        this.cacheStoreName = cacheStoreName;
    }

    public AuthTokenStore getAuthTokenStore() {
        return this.authTokenStore;
    }

    public void setAuthTokenStore(AuthTokenStore authTokenStore) {
        this.authTokenStore = authTokenStore;
    }

    @Override
    public AuthToken getBySeries(int tenantId, String type, String series) {
        return this.tokenCache.get(new AuthTokenKey(tenantId, type, series));
    }

    @Override
    public List<AuthToken> getByOwner(int tenantId, String userUniqueKey) {
        return this.authTokenStore.getByOwner(tenantId, userUniqueKey);
    }

    @Override
    public void create(AuthToken token) {
        this.authTokenStore.create(token);
        this.tokenCache.notifyCreate(token);
        Transaction t = Transaction.getCurrent();
        if (t.getStatus() == TransactionStatus.ACTIVE) {
            t.afterRollback(() -> this.tokenCache.notifyInvalid(token));
        }
    }

    @Override
    public void update(AuthToken newToken, AuthToken currentToken) {
        this.authTokenStore.update(newToken, currentToken);
        this.tokenCache.notifyUpdate(newToken);
        Transaction t = Transaction.getCurrent();
        if (t.getStatus() == TransactionStatus.ACTIVE) {
            t.afterRollback(() -> this.tokenCache.notifyInvalid(newToken));
        }
    }

    @Override
    public void delete(int tenantId, String type, String userUniqueKey) {
        List<AuthToken> lists = this.getByOwner(tenantId, userUniqueKey);
        this.authTokenStore.delete(tenantId, type, userUniqueKey);
        if (lists != null && lists.size() > 0) {
            ArrayList<AuthTokenKey> keys = new ArrayList<AuthTokenKey>();
            for (AuthToken t : lists) {
                if (!t.getType().equals(type)) continue;
                AuthTokenKey key = new AuthTokenKey(t.getTenantId(), t.getType(), t.getSeries());
                this.tokenCache.notifyDeleteByKey(key);
                keys.add(key);
            }
            Transaction t = Transaction.getCurrent();
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                t.afterCommit(() -> {
                    for (AuthTokenKey k : keys) {
                        this.tokenCache.notifyInvalidByKey(k);
                    }
                });
            }
        }
    }

    @Override
    public void deleteBySeries(int tenantId, String type, String series) {
        this.authTokenStore.deleteBySeries(tenantId, type, series);
        AuthTokenKey key = new AuthTokenKey(tenantId, type, series);
        this.tokenCache.notifyDeleteByKey(key);
        Transaction t = Transaction.getCurrent();
        if (t.getStatus() == TransactionStatus.ACTIVE) {
            t.afterCommit(() -> this.tokenCache.notifyInvalidByKey(key));
        }
    }

    @Override
    public void deleteByDate(int tenantId, String type, Timestamp ts) {
        this.authTokenStore.deleteByDate(tenantId, type, ts);
    }

    public static class AuthTokenKeyResolver
    implements CacheKeyResolver {
        @Override
        public String toString(Object cacheKey) {
            AuthTokenKey key = (AuthTokenKey)cacheKey;
            StringBuilder sb = new StringBuilder();
            sb.append(key.getTenantId()).append(':').append(key.getType()).append(':').append(key.getSeries());
            return sb.toString();
        }

        @Override
        public Object toCacheKey(String cacheKeyString) {
            int index = cacheKeyString.indexOf(58);
            int tenantId = Integer.parseInt(cacheKeyString.substring(0, index));
            int index2 = cacheKeyString.indexOf(index + 1, 58);
            String type = cacheKeyString.substring(index, index2);
            String series = cacheKeyString.substring(index2 + 1);
            return new AuthTokenKey(tenantId, type, series);
        }
    }

    private static class AuthTokenKey
    implements Serializable {
        private static final long serialVersionUID = 6033114232648174950L;
        private final int tenantId;
        private final String type;
        private final String series;

        public AuthTokenKey(int tenantId, String type, String series) {
            this.tenantId = tenantId;
            this.type = type;
            this.series = series;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public String getType() {
            return this.type;
        }

        public String getSeries() {
            return this.series;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.series == null ? 0 : this.series.hashCode());
            result = 31 * result + this.tenantId;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AuthTokenKey other = (AuthTokenKey)obj;
            if (this.series == null ? other.series != null : !this.series.equals(other.series)) {
                return false;
            }
            if (this.tenantId != other.tenantId) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

