/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.entity;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.AuthQueryASTTransformer;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.EntityPermissionEntry;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.EntityPropertyPermissionEntry;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BuiltinEntityAuthContext
extends BuiltinAuthorizationContext
implements EntityAuthContext {
    private static final Logger logger = LoggerFactory.getLogger(BuiltinEntityAuthContext.class);
    private static final HashSet<String> systemUseProperty = new HashSet();
    private EnumMap<EntityPermission.Action, EntityPermissionEntry[]> entityPermissionEntry;
    private EnumMap<EntityPropertyPermission.Action, EntityPropertyPermissionEntry[]> entityPropertyPermissionEntry;
    private TenantAuthorizeContext tenantAuthContext;

    BuiltinEntityAuthContext(String entityDefinitionName, EnumMap<EntityPermission.Action, EntityPermissionEntry[]> entityPermissionEntry, EnumMap<EntityPropertyPermission.Action, EntityPropertyPermissionEntry[]> entityPropertyPermissionEntry, TenantAuthorizeContext tenantAuthContext) {
        super(entityDefinitionName);
        this.tenantAuthContext = tenantAuthContext;
        this.entityPermissionEntry = entityPermissionEntry;
        this.entityPropertyPermissionEntry = entityPropertyPermissionEntry;
    }

    BuiltinEntityAuthContext(String entityDefinitionName, EntityPermissionEntry[] createEntityPermissionEntry, EntityPermissionEntry[] referenceEntityPermissionEntry, EntityPermissionEntry[] updateEntityPermissionEntry, EntityPermissionEntry[] deleteEntityPermissionEntry, EntityPropertyPermissionEntry[] createEntityPropertyPermissionEntry, EntityPropertyPermissionEntry[] referenceEntityPropertyPermissionEntry, EntityPropertyPermissionEntry[] updateEntityPropertyPermissionEntry, TenantAuthorizeContext tenantAuthContext) {
        super(entityDefinitionName);
        this.tenantAuthContext = tenantAuthContext;
        this.entityPermissionEntry = new EnumMap(EntityPermission.Action.class);
        if (createEntityPermissionEntry != null && createEntityPermissionEntry.length != 0) {
            this.entityPermissionEntry.put(EntityPermission.Action.CREATE, createEntityPermissionEntry);
        }
        if (referenceEntityPermissionEntry != null && referenceEntityPermissionEntry.length != 0) {
            this.entityPermissionEntry.put(EntityPermission.Action.REFERENCE, referenceEntityPermissionEntry);
        }
        if (updateEntityPermissionEntry != null && updateEntityPermissionEntry.length != 0) {
            this.entityPermissionEntry.put(EntityPermission.Action.UPDATE, updateEntityPermissionEntry);
        }
        if (deleteEntityPermissionEntry != null && deleteEntityPermissionEntry.length != 0) {
            this.entityPermissionEntry.put(EntityPermission.Action.DELETE, deleteEntityPermissionEntry);
        }
        this.entityPropertyPermissionEntry = new EnumMap(EntityPropertyPermission.Action.class);
        if (createEntityPropertyPermissionEntry != null && createEntityPropertyPermissionEntry.length != 0) {
            this.entityPropertyPermissionEntry.put(EntityPropertyPermission.Action.CREATE, createEntityPropertyPermissionEntry);
        }
        if (referenceEntityPropertyPermissionEntry != null && referenceEntityPropertyPermissionEntry.length != 0) {
            this.entityPropertyPermissionEntry.put(EntityPropertyPermission.Action.REFERENCE, referenceEntityPropertyPermissionEntry);
        }
        if (updateEntityPropertyPermissionEntry != null && updateEntityPropertyPermissionEntry.length != 0) {
            this.entityPropertyPermissionEntry.put(EntityPropertyPermission.Action.UPDATE, updateEntityPropertyPermissionEntry);
        }
    }

    TenantAuthorizeContext getTenantAuthContext() {
        return this.tenantAuthContext;
    }

    private List<EntityPermissionEntry> listEntityTarget(EntityPermission.Action action, AuthContextHolder userAuthContext) {
        EntityPermissionEntry[] toList = this.entityPermissionEntry.get((Object)action);
        if (toList == null) {
            return null;
        }
        LinkedList<EntityPermissionEntry> target = new LinkedList<EntityPermissionEntry>();
        long currentPriority = 0L;
        for (int i = 0; i < toList.length; ++i) {
            if (!userAuthContext.userInRole(toList[i].getRole(), this.tenantAuthContext.getTenantContext().getTenantId())) continue;
            RoleContext role = this.tenantAuthContext.getRoleContext(toList[i].getRole());
            if (currentPriority < role.getPriority()) {
                currentPriority = role.getPriority();
                target.clear();
            }
            if (currentPriority != role.getPriority()) continue;
            target.add(toList[i]);
        }
        return target;
    }

    private List<EntityPermissionEntry> listEntityTarget(EntityPermission.Action action, String role) {
        EntityPermissionEntry[] toList = this.entityPermissionEntry.get((Object)action);
        if (toList == null) {
            return null;
        }
        LinkedList<EntityPermissionEntry> target = new LinkedList<EntityPermissionEntry>();
        for (int i = 0; i < toList.length; ++i) {
            if (!toList[i].getRole().equals(role)) continue;
            target.add(toList[i]);
        }
        return target;
    }

    private List<EntityPropertyPermissionEntry> listEntityPropertyTarget(EntityPropertyPermission.Action action, AuthContextHolder userAuthContext) {
        EntityPropertyPermissionEntry[] toList = this.entityPropertyPermissionEntry.get((Object)action);
        if (toList == null) {
            return null;
        }
        LinkedList<EntityPropertyPermissionEntry> target = new LinkedList<EntityPropertyPermissionEntry>();
        long currentPriority = 0L;
        for (int i = 0; i < toList.length; ++i) {
            if (!userAuthContext.userInRole(toList[i].getRole(), this.tenantAuthContext.getTenantContext().getTenantId())) continue;
            RoleContext role = this.tenantAuthContext.getRoleContext(toList[i].getRole());
            if (currentPriority < role.getPriority()) {
                currentPriority = role.getPriority();
                target.clear();
            }
            if (currentPriority != role.getPriority()) continue;
            target.add(toList[i]);
        }
        return target;
    }

    @Override
    public boolean isPermit(Permission permission, AuthContextHolder user) {
        if (permission instanceof EntityPermission) {
            return this.isPermit(((EntityPermission)permission).getAction(), user);
        }
        EntityPropertyPermission epp = (EntityPropertyPermission)permission;
        return this.isPermit(epp.getPropertyName(), epp.getAction(), user);
    }

    @Override
    public boolean isResultCacheable(Permission permission) {
        return true;
    }

    boolean isPermit(EntityPermission.Action action, AuthContextHolder userAuthContext) {
        UserBinding user = userAuthContext.newUserBinding(this.tenantAuthContext);
        if (user.isGrantAllPermissions()) {
            return true;
        }
        boolean ret = false;
        List<EntityPermissionEntry> checkTargetList = this.listEntityTarget(action, userAuthContext);
        if (checkTargetList != null) {
            for (EntityPermissionEntry c : checkTargetList) {
                if (!c.isPermit()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    boolean isPermit(String propertyName, EntityPropertyPermission.Action action, AuthContextHolder userAuthContext) {
        UserBinding user = userAuthContext.newUserBinding(this.tenantAuthContext);
        if (user.isGrantAllPermissions()) {
            return true;
        }
        boolean ret = false;
        if (action == EntityPropertyPermission.Action.REFERENCE && systemUseProperty.contains(propertyName)) {
            ret = this.isPermit(EntityPermission.Action.REFERENCE, userAuthContext);
        } else {
            List<EntityPropertyPermissionEntry> checkTarget = this.listEntityPropertyTarget(action, userAuthContext);
            if (checkTarget != null) {
                for (EntityPropertyPermissionEntry c : checkTarget) {
                    List<EntityPermissionEntry> checkEntityTarget;
                    if (c.isPermit(propertyName) && (checkEntityTarget = this.listEntityTarget(this.toEntityAction(action), c.getRole())) != null) {
                        for (EntityPermissionEntry e : checkEntityTarget) {
                            if (!e.isPermit()) continue;
                            ret = true;
                            break;
                        }
                    }
                    if (!ret) continue;
                    break;
                }
            }
        }
        return ret;
    }

    private EntityPermission.Action toEntityAction(EntityPropertyPermission.Action action) {
        switch (action) {
            case CREATE: {
                return EntityPermission.Action.CREATE;
            }
            case REFERENCE: {
                return EntityPermission.Action.REFERENCE;
            }
            case UPDATE: {
                return EntityPermission.Action.UPDATE;
            }
        }
        return null;
    }

    @Override
    public Condition addLimitingCondition(Condition orignal, EntityPermission.Action action, AuthContextHolder userAuthContext) {
        UserBinding user = userAuthContext.newUserBinding(this.tenantAuthContext);
        if (user.isGrantAllPermissions()) {
            return orignal;
        }
        List<EntityPermissionEntry> checkTarget = this.listEntityTarget(action, userAuthContext);
        if (checkTarget == null || checkTarget.size() == 0) {
            throw new NoPermissionException("access denyed:" + this.getContextName());
        }
        Or or = new Or();
        boolean isPermit = false;
        boolean hasNoCondition = false;
        for (EntityPermissionEntry c : checkTarget) {
            if (c.isPermit()) {
                isPermit = true;
            }
            if (c.hasLimitCondition()) {
                or.addExpression(c.getCondition(user, this.tenantAuthContext));
                continue;
            }
            hasNoCondition = true;
        }
        if (!isPermit) {
            throw new NoPermissionException("access denyed:" + this.getContextName());
        }
        if (hasNoCondition) {
            return orignal;
        }
        if (orignal == null) {
            return or.strip();
        }
        return new And(orignal, or.strip());
    }

    @Override
    public Query modifyQuery(Query orignal, EntityPermission.Action action, AuthContextHolder userAuthContext) {
        return this.modifyQuery(orignal, action, null, userAuthContext);
    }

    @Override
    public Query modifyQuery(Query orignal, EntityPermission.Action action, EntityPropertyPermission.Action propAction, AuthContextHolder userAuthContext) {
        EntityContext entityContext;
        EntityHandler eh;
        long time = 0L;
        if (logger.isDebugEnabled()) {
            time = System.currentTimeMillis();
        }
        if ((eh = (entityContext = EntityContext.getCurrentContext()).getHandlerByName(this.getContextName())) == null) {
            throw new EntityRuntimeException(this.getContextName() + " is undefined.");
        }
        AuthQueryASTTransformer t = new AuthQueryASTTransformer(this.tenantAuthContext, this, action, propAction, userAuthContext, eh, entityContext, null);
        Query authedQuery = t.transform(orignal);
        if (logger.isDebugEnabled()) {
            logger.debug("modifyQuery " + (Object)((Object)action) + "(" + (Object)((Object)propAction) + ") :time=" + (System.currentTimeMillis() - time) + "ms. orginal=" + orignal + " : authed=" + authedQuery);
        }
        return authedQuery;
    }

    @Override
    public boolean hasLimitCondition(EntityPermission permission, AuthContextHolder userAuthContext) {
        UserBinding user = userAuthContext.newUserBinding(this.tenantAuthContext);
        if (user.isGrantAllPermissions()) {
            return false;
        }
        List<EntityPermissionEntry> checkTarget = this.listEntityTarget(permission.getAction(), userAuthContext);
        if (checkTarget == null || checkTarget.size() == 0) {
            throw new NoPermissionException("access denyed:" + this.getContextName());
        }
        for (EntityPermissionEntry c : checkTarget) {
            if (c.hasLimitCondition()) continue;
            return false;
        }
        return true;
    }

    static {
        systemUseProperty.add("oid");
        systemUseProperty.add("version");
        systemUseProperty.add("updateDate");
        systemUseProperty.add("state");
        systemUseProperty.add("lockedBy");
        systemUseProperty.add("startDate");
        systemUseProperty.add("endDate");
        systemUseProperty.add("recycleBinId");
    }
}

