/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store;

import java.io.Serializable;
import java.util.Arrays;

public class CacheEntry
implements Serializable {
    private static final long serialVersionUID = 6317374211009297155L;
    private final Object key;
    private final Object value;
    private final long version;
    private final Object[] indexValues;
    private final long creationTime;

    public CacheEntry(Object key, Object value, long version, long creationTime, Object ... indexValues) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.creationTime = creationTime;
        this.indexValues = indexValues;
    }

    public CacheEntry(Object key, Object value, long version, Object ... indexValues) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.indexValues = indexValues;
        this.creationTime = System.currentTimeMillis();
    }

    public CacheEntry(Object key, Object value, Object ... indexValues) {
        this.key = key;
        this.value = value;
        this.version = System.currentTimeMillis();
        this.indexValues = indexValues;
        this.creationTime = this.version;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getVersion() {
        return this.version;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getIndexValue(int indexKey) {
        if (this.indexValues == null) {
            return null;
        }
        if (this.indexValues.length <= indexKey) {
            return null;
        }
        return this.indexValues[indexKey];
    }

    public Object[] getIndexValues() {
        return this.indexValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        if (this.creationTime != other.creationTime) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [key=" + this.key + ", value=" + this.value + ", version=" + this.version + ", indexValues=" + Arrays.deepToString(this.indexValues) + ", creationTime=" + this.creationTime + "]";
    }
}

