/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import javax.el.BeanNameELResolver;
import javax.el.BeanNameResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.PropertyNotWritableException;
import javax.el.VariableMapper;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.command.beanmapper.el.ArrayTypeConverter;
import org.iplass.mtp.impl.command.beanmapper.el.BinaryReferenceConverter;
import org.iplass.mtp.impl.command.beanmapper.el.ELMapper;
import org.iplass.mtp.impl.command.beanmapper.el.ExtendedArrayELResolver;
import org.iplass.mtp.impl.command.beanmapper.el.ExtendedBeanELResolver;
import org.iplass.mtp.impl.command.beanmapper.el.ExtendedListELResolver;
import org.iplass.mtp.impl.command.beanmapper.el.ExtendedMapELResolver;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyInfo;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyRef;
import org.iplass.mtp.impl.command.beanmapper.el.SelectValueConverter;
import org.iplass.mtp.impl.command.beanmapper.el.SqlDateConverter;
import org.iplass.mtp.impl.command.beanmapper.el.TimeConverter;
import org.iplass.mtp.impl.command.beanmapper.el.TimestampConverter;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

public class BeanMapperELContext
extends ELContext {
    static final String ROOT_NAME = "R";
    private ELResolver elResolver;
    private Object bean;
    private ELMapper elMapper;
    private IdentityHashMap<Object, PropertyRef> propertyRefs;

    public BeanMapperELContext(Object bean, ELMapper elMapper) {
        this.bean = bean;
        this.elMapper = elMapper;
        this.putContext(BeanMapperELContext.class, (Object)this);
    }

    PropertyRef getPropertyRef(Object propValue) {
        if (this.propertyRefs == null) {
            return null;
        }
        return this.propertyRefs.get(propValue);
    }

    void setPropertyRef(Object bean, PropertyInfo propertyInfo, Object propValue) {
        switch (propertyInfo.getTypeKind()) {
            case ARRAY: 
            case LIST: 
            case MAP: {
                if (this.propertyRefs == null) {
                    this.propertyRefs = new IdentityHashMap();
                }
                this.propertyRefs.put(propValue, new PropertyRef(bean, propertyInfo));
                break;
            }
        }
    }

    void setPropertyRef(Object bean, ReferencePropertyHandler rph, Object propValue) {
        if (rph.getMetaData().getMultiplicity() != 1) {
            if (this.propertyRefs == null) {
                this.propertyRefs = new IdentityHashMap();
            }
            this.propertyRefs.put(propValue, new PropertyRef(bean, rph));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void replacePropertyRef(Object oldPropValue, Object newPropValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.propertyRefs == null) {
            return;
        }
        PropertyRef propertyRef = this.propertyRefs.remove(oldPropValue);
        this.propertyRefs.put(newPropValue, propertyRef);
        if (propertyRef.getPropertyInfo() != null) {
            Method setter = propertyRef.getPropertyInfo().getWriteMethod();
            if (setter != null) {
                setter.invoke(propertyRef.getBean(), newPropValue);
                return;
            } else {
                if (!(propertyRef.getBean() instanceof Entity)) throw new PropertyNotWritableException("The class:" + propertyRef.getBean().getClass().getName() + " does not have a writable property:" + propertyRef.getPropertyName());
                ((Entity)propertyRef.getBean()).setValue(propertyRef.getPropertyName(), newPropValue);
            }
            return;
        } else {
            ((Entity)propertyRef.getBean()).setValue(propertyRef.getPropertyName(), newPropValue);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public ELMapper getElMapper() {
        return this.elMapper;
    }

    public ELResolver getELResolver() {
        if (this.elResolver == null) {
            CompositeELResolver resolver = new CompositeELResolver();
            resolver.add((ELResolver)new BinaryReferenceConverter());
            resolver.add((ELResolver)new SelectValueConverter());
            resolver.add((ELResolver)new SqlDateConverter());
            resolver.add((ELResolver)new TimeConverter());
            resolver.add((ELResolver)new TimestampConverter());
            resolver.add((ELResolver)new ArrayTypeConverter());
            resolver.add((ELResolver)new BeanNameELResolver((BeanNameResolver)new LocalBeanNameResolver()));
            resolver.add((ELResolver)new ExtendedMapELResolver());
            resolver.add((ELResolver)new ExtendedListELResolver());
            resolver.add((ELResolver)new ExtendedArrayELResolver());
            resolver.add((ELResolver)new ExtendedBeanELResolver());
            this.elResolver = resolver;
        }
        return this.elResolver;
    }

    public FunctionMapper getFunctionMapper() {
        return null;
    }

    public VariableMapper getVariableMapper() {
        return null;
    }

    public Object convertToType(Object obj, Class<?> targetType) {
        if (obj instanceof String && targetType != String.class) {
            if (this.elMapper.isTrim()) {
                obj = ((String)obj).trim();
            }
            if (this.elMapper.isEmptyToNull() && ((String)obj).isEmpty()) {
                obj = null;
            }
        }
        return super.convertToType(obj, targetType);
    }

    private class LocalBeanNameResolver
    extends BeanNameResolver {
        private LocalBeanNameResolver() {
        }

        public boolean isNameResolved(String beanName) {
            return BeanMapperELContext.ROOT_NAME.equals(beanName);
        }

        public Object getBean(String beanName) {
            if (this.isNameResolved(beanName)) {
                return BeanMapperELContext.this.bean;
            }
            return null;
        }

        public void setBeanValue(String beanName, Object value) {
        }

        public boolean isReadOnly(String beanName) {
            return false;
        }

        public boolean canCreateBean(String beanName) {
            return false;
        }
    }
}

