/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.iplass.mtp.impl.core.config.ServiceRegistryInitializer;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEnv {
    private static Logger logger = LoggerFactory.getLogger(ServerEnv.class);
    public static final String SERVER_ID_DEF_SYSTEM_PROP_NAME = "mtp.server.myserverid";
    public static final String SERVER_NAME_DEF_SYSTEM_PROP_NAME = "mtp.server.myservername";
    public static final String INTERFACE_NAME_DEF_SYSTEM_PROP_NAME = "mtp.server.myinterfacename";
    private static ServerEnv instance = new ServerEnv();
    private final Properties props;

    public static ServerEnv getInstance() {
        return instance;
    }

    private ServerEnv() {
        String fileName = ServiceRegistryInitializer.getServerEnvFileName();
        if (fileName != null) {
            try (InputStream is = this.getClass().getResourceAsStream(fileName);){
                if (is == null) {
                    logger.debug("mtp.server.env:" + fileName + " not found.use SystemProperty as server env config.");
                    this.props = System.getProperties();
                }
                Properties p = new Properties();
                p.load(new InputStreamReader(is, "UTF-8"));
                this.props = p;
            }
            catch (IOException e) {
                throw new ServiceConfigrationException("cant load server env file:" + fileName, e);
            }
        } else {
            logger.debug("mtp.server.env not specified.use SystemProperty as server env config.");
            this.props = System.getProperties();
        }
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String def) {
        return this.props.getProperty(key, def);
    }

    public String getServerId() {
        String id = this.getProperty(SERVER_ID_DEF_SYSTEM_PROP_NAME);
        if (id == null) {
            try {
                id = this.getServerNameAndAddress()[0];
            }
            catch (SocketException e) {
                throw new IllegalStateException(e);
            }
        }
        return id;
    }

    public String[] getServerNameAndAddress() throws SocketException {
        Enumeration<InetAddress> addresses;
        String defHostName = this.getProperty(SERVER_NAME_DEF_SYSTEM_PROP_NAME);
        if (defHostName != null) {
            return new String[]{defHostName};
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        String networkInterfaceName = this.getProperty(INTERFACE_NAME_DEF_SYSTEM_PROP_NAME);
        NetworkInterface ni = null;
        NetworkInterface loopBack = null;
        if (networkInterfaceName != null) {
            ni = NetworkInterface.getByName(networkInterfaceName);
            if (ni == null) {
                throw new ServiceConfigrationException("networkInterfaceName:" + networkInterfaceName + " not found...");
            }
        } else {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface forCheck = e.nextElement();
                if (forCheck.isLoopback()) {
                    loopBack = forCheck;
                    continue;
                }
                if (!forCheck.isUp()) continue;
                ni = forCheck;
                break;
            }
        }
        if (ni != null) {
            addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        if (loopBack != null) {
            addresses = loopBack.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void addHostNameAndAddress(Set<String> list, InetAddress ia) {
        String hostName = ia.getHostName();
        if (ia.isLoopbackAddress()) {
            list.add("localhost");
            list.add(ia.getHostAddress());
        } else {
            list.add(hostName);
            String address = ia.getHostAddress();
            if (hostName.contains(".") && !address.equals(hostName)) {
                list.add(hostName.substring(0, hostName.indexOf(46)));
            }
            list.add(address);
        }
    }
}

