/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iplass.mtp.impl.core.config.DecodePreprocessor;
import org.iplass.mtp.impl.core.config.GroovyPreprocessor;
import org.iplass.mtp.impl.core.config.ServerEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryInitializer {
    private static Logger logger = LoggerFactory.getLogger(ServiceRegistryInitializer.class);
    public static final String CONFIG_FILE_NAME_SYSTEM_PROPERTY_NAME = "mtp.config";
    public static final String CRYPT_CONFIG_FILE_NAME_SYSTEM_PROPERTY_NAME = "mtp.config.crypt";
    public static final String SERVER_ENV_PROP_FILE_NAME = "mtp.server.env";
    public static final String DEFAULT_CONFIG_FILE_NAME = "/mtp-service-config.xml";
    private static volatile String configFileName;
    private static volatile String cryptConfigFileName;
    private static volatile String serverEnvFileName;
    private static volatile CopyOnWriteArrayList<String> configPreprocessorClassNames;

    public static List<String> getConfigPreprocessorClassNames() {
        return configPreprocessorClassNames;
    }

    public static void setConfigPreprocessorClassNames(List<String> configPreprocessorClassNames) {
        ServiceRegistryInitializer.configPreprocessorClassNames = configPreprocessorClassNames == null ? null : new CopyOnWriteArrayList<String>(configPreprocessorClassNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerEnvFileName() {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (serverEnvFileName == null) {
                serverEnvFileName = System.getProperty(SERVER_ENV_PROP_FILE_NAME);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverEnvFileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServerEnvFileName(String serverEnvFileName) {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (ServiceRegistryInitializer.serverEnvFileName != null && !ServiceRegistryInitializer.serverEnvFileName.equals(serverEnvFileName)) {
                logger.warn("ServerEnvFileName already set to " + ServiceRegistryInitializer.serverEnvFileName + ". If ServiceRegistry already inited, you need to call ServiceRegistry's reInit method.");
            }
            ServiceRegistryInitializer.serverEnvFileName = serverEnvFileName;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceConfigFileName(String configFileName) {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (!configFileName.equals(ServiceRegistryInitializer.configFileName)) {
                logger.debug("replace ServiceConfigFileName from " + ServiceRegistryInitializer.configFileName + " to " + configFileName);
                ServiceRegistryInitializer.configFileName = configFileName;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfigFileName(String configFileName) {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (ServiceRegistryInitializer.configFileName != null && !ServiceRegistryInitializer.configFileName.equals(configFileName)) {
                logger.warn("ServiceConfigFileName already set to " + ServiceRegistryInitializer.configFileName + ". If ServiceRegistry already inited, you need to call ServiceRegistry's reInit method.");
            }
            logger.debug("set ServiceConfigFileName to " + configFileName);
            ServiceRegistryInitializer.configFileName = configFileName;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigFileName() {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (configFileName == null) {
                configFileName = ServerEnv.getInstance().getProperty(CONFIG_FILE_NAME_SYSTEM_PROPERTY_NAME, DEFAULT_CONFIG_FILE_NAME);
                logger.debug("set ServiceConfigFileName to " + configFileName);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return configFileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSetConfigFileName() {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return configFileName != null && configFileName.length() != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCryptoConfigFileName() {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (cryptConfigFileName == null) {
                cryptConfigFileName = ServerEnv.getInstance().getProperty(CRYPT_CONFIG_FILE_NAME_SYSTEM_PROPERTY_NAME);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cryptConfigFileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCryptoConfigFileName(String cryptConfigFileName) {
        Class<ServiceRegistryInitializer> clazz = ServiceRegistryInitializer.class;
        synchronized (ServiceRegistryInitializer.class) {
            if (ServiceRegistryInitializer.cryptConfigFileName != null && !ServiceRegistryInitializer.cryptConfigFileName.equals(cryptConfigFileName)) {
                logger.warn("CryptoConfigFileName already set to " + ServiceRegistryInitializer.cryptConfigFileName + ". If ServiceRegistry already inited, you need to call ServiceRegistry's reInit method.");
            }
            ServiceRegistryInitializer.cryptConfigFileName = cryptConfigFileName;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        configPreprocessorClassNames = new CopyOnWriteArrayList<String>(new String[]{GroovyPreprocessor.class.getName(), DecodePreprocessor.class.getName()});
    }
}

