/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.hint.IndexHint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlConverter;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.properties.extend.VirtualType;
import org.iplass.mtp.impl.rdb.adapter.MultiTableUpdateMethod;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class ObjStoreUpdateSql
extends UpdateSqlHandler {
    private static final String TMP_TABLE_ALIAS = "tt";

    public static boolean canUpdateProperty(PropertyHandler pHandler) {
        if (pHandler instanceof ReferencePropertyHandler) {
            return false;
        }
        PrimitivePropertyHandler pph = (PrimitivePropertyHandler)pHandler;
        if (pph.getMetaData().getType() instanceof VirtualType) {
            return false;
        }
        String propName = pHandler.getName();
        return !propName.equals("oid") && !propName.equals("updateDate") && !propName.equals("version");
    }

    private Object getValueAt(int i, Object value) {
        if (value instanceof Object[]) {
            if (i < ((Object[])value).length) {
                return ((Object[])value)[i];
            }
            return null;
        }
        if (i == 0) {
            return value;
        }
        return null;
    }

    private boolean handlePropAndVal(StringBuilder sb, int tenantId, EntityHandler eh, Entity model, List<String> updatePropNames, int pageNo, RdbAdapter rdbAdaptor, EntityContext context) {
        boolean added = false;
        for (String propName : updatePropNames) {
            PropertyHandler pHandler = eh.getProperty(propName, context);
            if (!ObjStoreUpdateSql.canUpdateProperty(pHandler)) continue;
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)pHandler.getStoreSpecProperty());
            Object val = model.getValue(propName);
            List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
            block5: for (int i = 0; i < cols.size(); ++i) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler tcol = cols.get(i);
                Object valToSet = this.getValueAt(i, val);
                if (tcol.getMetaData().getPageNo() == pageNo) {
                    if (added) {
                        sb.append(",");
                    } else {
                        added = true;
                    }
                    sb.append(tcol.getMetaData().getColumnName());
                    sb.append("=");
                    if (col.isNative()) {
                        col.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(valToSet, sb, rdbAdaptor);
                    } else {
                        col.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> col.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(valToSet, sb, rdbAdaptor));
                    }
                }
                if (tcol.getIndexColName() == null || tcol.getMetaData().getIndexPageNo() != pageNo) continue;
                if (added) {
                    sb.append(",");
                } else {
                    added = true;
                }
                switch (tcol.getIndexType()) {
                    case UNIQUE: {
                        sb.append(tcol.getIndexColName()).append("_TD");
                        sb.append("=");
                        sb.append("'");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdbAdaptor.sanitize(pHandler.getParent().getMetaData().getId()), pageNo));
                        sb.append("',");
                        sb.append(tcol.getIndexColName());
                        sb.append("=");
                        col.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> col.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(valToSet, sb, rdbAdaptor));
                        continue block5;
                    }
                    case UNIQUE_WITHOUT_NULL: 
                    case NON_UNIQUE: {
                        if (valToSet != null) {
                            sb.append(tcol.getIndexColName()).append("_TD");
                            sb.append("=");
                            sb.append("'");
                            sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdbAdaptor.sanitize(pHandler.getParent().getMetaData().getId()), pageNo));
                            sb.append("',");
                            sb.append(tcol.getIndexColName());
                            sb.append("=");
                            col.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> col.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(valToSet, sb, rdbAdaptor));
                            continue block5;
                        }
                        sb.append(tcol.getIndexColName()).append("_TD");
                        sb.append("=null,");
                        sb.append(tcol.getIndexColName());
                        sb.append("=null");
                        continue block5;
                    }
                }
            }
        }
        return added;
    }

    public String updateMain(int tenantId, EntityHandler eh, Entity model, boolean withTimestampCheck, List<String> updatePropNames, RdbAdapter rdbAdaptor, EntityContext context) {
        Timestamp updateDate = model.getUpdateDate();
        if (withTimestampCheck && updateDate == null) {
            throw new NullPointerException("for optimistic lock check, updateDate property value must specify, but null.");
        }
        int pageNo = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" SET ");
        boolean isAdded = this.handlePropAndVal(sb, tenantId, eh, model, updatePropNames, pageNo, rdbAdaptor, context);
        if (isAdded) {
            sb.append(",");
        }
        sb.append("UP_DATE=");
        if (withTimestampCheck) {
            long currentTime = System.currentTimeMillis();
            if (updateDate.getTime() >= currentTime) {
                currentTime = updateDate.getTime() + 1L;
            }
            sb.append(rdbAdaptor.toTimeStampExpression(new Timestamp(currentTime)));
        } else {
            sb.append(rdbAdaptor.systimestamp());
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdbAdaptor.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='").append(rdbAdaptor.sanitize(model.getOid())).append("'");
        if (model.getVersion() != null) {
            sb.append(" AND OBJ_VER=").append(model.getVersion());
        } else {
            sb.append(" AND OBJ_VER=0");
        }
        sb.append(" AND PG_NO=").append(pageNo);
        sb.append(" AND OBJ_DEF_VER<=").append(((MetaGRdbEntityStore)eh.getEntityStoreRuntime().getMetaData()).getVersion());
        if (withTimestampCheck) {
            sb.append(" AND UP_DATE=").append(rdbAdaptor.toTimeStampExpression(updateDate));
        }
        return sb.toString();
    }

    public String updateSub(int tenantId, EntityHandler eh, Entity model, List<String> updatePropNames, int pageNo, RdbAdapter rdbAdaptor, EntityContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" SET ");
        boolean isAdded = this.handlePropAndVal(sb, tenantId, eh, model, updatePropNames, pageNo, rdbAdaptor, context);
        if (!isAdded) {
            return null;
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdbAdaptor.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='").append(rdbAdaptor.sanitize(model.getOid())).append("'");
        if (model.getVersion() != null) {
            sb.append(" AND OBJ_VER=").append(model.getVersion());
        } else {
            sb.append(" AND OBJ_VER=0");
        }
        sb.append(" AND PG_NO=").append(pageNo);
        return sb.toString();
    }

    private String valueExp(ValueExpression val, EntityHandler eh, GRdbPropertyStoreRuntime col, int pageNo, RdbAdapter rdbAdaptor, EntityContext context) {
        String valStr = null;
        if (val == null) {
            valStr = "null";
        } else if (val instanceof Literal) {
            Object literalValue = ((Literal)val).getValue();
            if (literalValue == null) {
                valStr = "null";
            } else {
                StringBuilder vsb = new StringBuilder();
                if (col.isNative()) {
                    col.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(literalValue, vsb, rdbAdaptor);
                } else {
                    col.getSingleColumnRdbTypeAdapter().appendToTypedCol(vsb, rdbAdaptor, () -> col.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(literalValue, vsb, rdbAdaptor));
                }
                valStr = vsb.toString();
            }
        } else {
            HasOtherPageChecker chk = new HasOtherPageChecker(pageNo, eh, context);
            val.accept(chk);
            if (chk.hasOtherPage && rdbAdaptor.getMultiTableUpdateMethod() != MultiTableUpdateMethod.DIRECT_JOIN) {
                SqlQueryContext qc = new SqlQueryContext(eh, context, rdbAdaptor, "u", false);
                SqlConverter conv = new SqlConverter(qc, false);
                Query q = new Query().select(val).from(eh.getMetaData().getName());
                q.select().addHint(new IndexHint("name"));
                q.accept(conv);
                StringBuilder vsb = new StringBuilder();
                vsb.append("(");
                vsb.append(qc.toSelectSql());
                String mainTable = this.tableNameAlias(pageNo);
                vsb.append(" AND ").append(mainTable).append(".OBJ_ID=u.OBJ_ID");
                vsb.append(" AND ").append(mainTable).append(".OBJ_VER=u.OBJ_VER");
                vsb.append(")");
                if (col.isNative()) {
                    valStr = vsb.toString();
                } else {
                    StringBuilder vsb2 = new StringBuilder();
                    col.getSingleColumnRdbTypeAdapter().appendToTypedCol(vsb2, rdbAdaptor, () -> vsb2.append((CharSequence)vsb));
                    valStr = vsb2.toString();
                }
            } else {
                SqlQueryContext qc = new SqlQueryContext(eh, context, rdbAdaptor, "m", false);
                qc.changeCurrentClause(SqlQueryContext.Clause.SELECT);
                SqlConverter conv = new SqlConverter(qc, false);
                new IndexHint("name").accept(conv);
                val.accept(conv);
                if (col.isNative()) {
                    valStr = qc.getCurrentSb().toString();
                } else {
                    StringBuilder vsb = new StringBuilder();
                    col.getSingleColumnRdbTypeAdapter().appendToTypedCol(vsb, rdbAdaptor, () -> vsb.append(qc.getCurrentSb().toString()));
                    valStr = vsb.toString();
                }
            }
        }
        return valStr;
    }

    private boolean handlePropAndValforUpdateAll(int tenantId, StringBuilder sb, EntityHandler eh, List<UpdateCondition.UpdateValue> values, int pageNo, RdbAdapter rdbAdaptor, EntityContext context) {
        boolean added = false;
        boolean needTableAlias = rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN;
        String mainTable = this.tableNameAlias(pageNo);
        for (UpdateCondition.UpdateValue uv : values) {
            PropertyHandler pHandler = eh.getProperty(uv.getEntityField(), context);
            if (!ObjStoreUpdateSql.canUpdateProperty(pHandler)) continue;
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)pHandler.getStoreSpecProperty());
            ValueExpression val = uv.getValue();
            List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
            block5: for (int i = 0; i < cols.size(); ++i) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler tcol = cols.get(i);
                String valueStr = null;
                if (tcol.getMetaData().getPageNo() == pageNo) {
                    if (added) {
                        sb.append(",");
                    } else {
                        added = true;
                    }
                    if (needTableAlias) {
                        sb.append(mainTable).append(".");
                    }
                    sb.append(tcol.getMetaData().getColumnName());
                    sb.append("=");
                    if (valueStr == null) {
                        valueStr = this.valueExp(val, eh, tcol, pageNo, rdbAdaptor, context);
                    }
                    sb.append(valueStr);
                }
                if (tcol.isExternalIndex() || tcol.getIndexColName() == null || tcol.getMetaData().getIndexPageNo() != pageNo) continue;
                if (added) {
                    sb.append(",");
                } else {
                    added = true;
                }
                if (needTableAlias) {
                    sb.append(mainTable).append(".");
                }
                sb.append(tcol.getIndexColName());
                sb.append("=");
                if (valueStr == null) {
                    valueStr = this.valueExp(val, eh, tcol, pageNo, rdbAdaptor, context);
                }
                sb.append(valueStr);
                sb.append(",");
                switch (tcol.getIndexType()) {
                    case UNIQUE: {
                        if (needTableAlias) {
                            sb.append(mainTable).append(".");
                        }
                        sb.append(tcol.getIndexColName()).append("_TD");
                        sb.append("=");
                        sb.append("'");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdbAdaptor.sanitize(pHandler.getParent().getMetaData().getId()), pageNo));
                        sb.append("'");
                        continue block5;
                    }
                    case UNIQUE_WITHOUT_NULL: 
                    case NON_UNIQUE: {
                        if (needTableAlias) {
                            sb.append(mainTable).append(".");
                        }
                        sb.append(tcol.getIndexColName()).append("_TD");
                        sb.append("=");
                        sb.append("CASE WHEN ").append(valueStr).append(" IS NULL THEN NULL ELSE '");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdbAdaptor.sanitize(pHandler.getParent().getMetaData().getId()), pageNo));
                        sb.append("' END");
                        continue block5;
                    }
                }
            }
        }
        return added;
    }

    private void multitableJoinClause(StringBuilder sb, int tenantId, int pageNo, EntityHandler eh, EntityContext ec, List<UpdateCondition.UpdateValue> values, String tableName, RdbAdapter rdb) {
        NeedOtherPageJoinChecker cheker = new NeedOtherPageJoinChecker(pageNo, eh, ec);
        Set<Integer> pns = cheker.check(values);
        String mainTable = this.tableNameAlias(pageNo);
        if (pns != null) {
            for (Integer i : pns) {
                String joinTable = this.tableNameAlias(i);
                sb.append(" INNER JOIN ").append(tableName).append(" ").append(joinTable);
                sb.append(" ON ").append(mainTable).append(".").append("TENANT_ID").append("=").append(joinTable).append(".").append("TENANT_ID");
                sb.append(" AND ").append(mainTable).append(".").append("OBJ_DEF_ID").append("=").append(joinTable).append(".").append("OBJ_DEF_ID");
                sb.append(" AND ").append(mainTable).append(".").append("OBJ_ID").append("=").append(joinTable).append(".").append("OBJ_ID");
                sb.append(" AND ").append(mainTable).append(".").append("OBJ_VER").append("=").append(joinTable).append(".").append("OBJ_VER");
                sb.append(" AND ").append(joinTable).append(".").append("PG_NO").append("=").append(i);
            }
        }
    }

    private String tableNameAlias(int pageNo) {
        if (pageNo == 0) {
            return "m";
        }
        return "mp" + pageNo;
    }

    public String updateAllSubByTempTable(int tenantId, EntityHandler eh, List<UpdateCondition.UpdateValue> values, String userId, int pageNo, RdbAdapter rdbAdaptor, EntityContext context) {
        StringBuilder sb = new StringBuilder();
        String mainTable = this.tableNameAlias(pageNo);
        if (rdbAdaptor.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append("UPDATE ").append(mainTable);
        } else {
            sb.append("UPDATE ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE()).append(" ").append(mainTable);
        }
        if (rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN) {
            this.multitableJoinClause(sb, tenantId, pageNo, eh, context, values, ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE(), rdbAdaptor);
        }
        sb.append(" SET ");
        boolean isAdd = this.handlePropAndValforUpdateAll(tenantId, sb, eh, values, pageNo, rdbAdaptor, context);
        if (!isAdd) {
            return null;
        }
        if (rdbAdaptor.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append(" FROM ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE()).append(" ").append(mainTable);
        }
        sb.append(" WHERE ").append(mainTable).append(".").append("TENANT_ID=").append(tenantId);
        sb.append(" AND ").append(mainTable).append(".").append("OBJ_DEF_ID='").append(rdbAdaptor.sanitize(eh.getMetaData().getId())).append("'");
        sb.append(" AND ").append(mainTable).append(".").append("PG_NO=").append(pageNo);
        if (rdbAdaptor.isSupportRowValueConstructor()) {
            sb.append(" AND (").append(mainTable).append(".").append("OBJ_ID,").append(mainTable).append(".").append("OBJ_VER) IN(SELECT OBJ_ID,OBJ_VER FROM " + rdbAdaptor.getTemplaryTablePrefix() + "OBJ_STORE_TMP" + ")");
        } else {
            sb.append(" AND EXISTS (");
            sb.append("SELECT 1 FROM ").append(rdbAdaptor.getTemplaryTablePrefix()).append("OBJ_STORE_TMP").append(" ").append(TMP_TABLE_ALIAS);
            sb.append(" WHERE ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_ID").append("=").append(mainTable).append(".").append("OBJ_ID");
            sb.append(" AND ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_VER").append("=").append(mainTable).append(".").append("OBJ_VER");
            sb.append(")");
        }
        return sb.toString();
    }

    public String updateAllMainByTempTable(int tenantId, EntityHandler eh, List<UpdateCondition.UpdateValue> values, String userId, RdbAdapter rdbAdaptor, EntityContext context) {
        int pageNo = 0;
        String mainTable = this.tableNameAlias(pageNo);
        StringBuilder sb = new StringBuilder();
        if (rdbAdaptor.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append("UPDATE ").append(mainTable);
        } else {
            sb.append("UPDATE ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE()).append(" ").append(mainTable);
        }
        if (rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN) {
            this.multitableJoinClause(sb, tenantId, pageNo, eh, context, values, ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE(), rdbAdaptor);
        }
        sb.append(" SET ");
        boolean isAdd = this.handlePropAndValforUpdateAll(tenantId, sb, eh, values, pageNo, rdbAdaptor, context);
        if (isAdd) {
            sb.append(",");
        }
        if (rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN) {
            sb.append(mainTable).append(".");
        }
        sb.append("UP_USER='").append(rdbAdaptor.sanitize(userId)).append("',");
        if (rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN) {
            sb.append(mainTable).append(".");
        }
        sb.append("UP_DATE=").append(rdbAdaptor.systimestamp());
        if (rdbAdaptor.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append(" FROM ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE()).append(" ").append(mainTable);
        }
        sb.append(" WHERE ").append(mainTable).append(".TENANT_ID=").append(tenantId);
        sb.append(" AND ").append(mainTable).append(".OBJ_DEF_ID='").append(rdbAdaptor.sanitize(eh.getMetaData().getId())).append("'");
        sb.append(" AND ").append(mainTable).append(".PG_NO=").append(pageNo);
        if (rdbAdaptor.isSupportRowValueConstructor()) {
            sb.append(" AND (").append(mainTable).append(".OBJ_ID,").append(mainTable).append(".OBJ_VER) IN(SELECT OBJ_ID,OBJ_VER FROM " + rdbAdaptor.getTemplaryTablePrefix() + "OBJ_STORE_TMP" + ")");
        } else {
            sb.append(" AND EXISTS (");
            sb.append("SELECT 1 FROM ").append(rdbAdaptor.getTemplaryTablePrefix()).append("OBJ_STORE_TMP").append(" ").append(TMP_TABLE_ALIAS);
            sb.append(" WHERE ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_ID").append("=").append(mainTable).append(".").append("OBJ_ID");
            sb.append(" AND ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_VER").append("=").append(mainTable).append(".").append("OBJ_VER");
            sb.append(")");
        }
        sb.append(" AND ").append(mainTable).append(".OBJ_DEF_VER<=").append(((MetaGRdbEntityStore)eh.getEntityStoreRuntime().getMetaData()).getVersion());
        return sb.toString();
    }

    public String updateAllOnlyMainByCondition(int tenantId, EntityHandler eh, UpdateCondition cond, String userId, RdbAdapter rdbAdaptor, EntityContext context) {
        int pageNo = 0;
        String mainTable = this.tableNameAlias(pageNo);
        StringBuilder sb = new StringBuilder();
        if (rdbAdaptor.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append("UPDATE ").append(mainTable);
        } else {
            sb.append("UPDATE ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE()).append(" ").append(mainTable);
        }
        sb.append(" SET ");
        boolean isAdd = this.handlePropAndValforUpdateAll(tenantId, sb, eh, cond.getValues(), pageNo, rdbAdaptor, context);
        if (isAdd) {
            sb.append(",");
        }
        if (rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN) {
            sb.append(mainTable).append(".");
        }
        sb.append("UP_USER='").append(rdbAdaptor.sanitize(userId)).append("',");
        if (rdbAdaptor.getMultiTableUpdateMethod() == MultiTableUpdateMethod.DIRECT_JOIN) {
            sb.append(mainTable).append(".");
        }
        sb.append("UP_DATE=").append(rdbAdaptor.systimestamp());
        if (rdbAdaptor.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append(" FROM ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE()).append(" ").append(mainTable);
        }
        sb.append(" WHERE ").append(mainTable).append(".TENANT_ID=").append(tenantId);
        sb.append(" AND ").append(mainTable).append(".OBJ_DEF_ID='").append(rdbAdaptor.sanitize(eh.getMetaData().getId())).append("'");
        sb.append(" AND ").append(mainTable).append(".PG_NO=").append(pageNo);
        if (rdbAdaptor.isSupportRowValueConstructor()) {
            sb.append(" AND (").append(mainTable).append(".OBJ_ID,").append(mainTable).append(".OBJ_VER) IN(");
        } else {
            sb.append(" AND EXISTS (");
        }
        Query q = new Query();
        q.selectDistinct("oid", "version").from(eh.getMetaData().getName()).setWhere(cond.getWhere());
        SqlQueryContext qc = new SqlQueryContext(eh, context, rdbAdaptor);
        SqlConverter conv = new SqlConverter(qc, false);
        q.accept(conv);
        if (rdbAdaptor.isSupportRowValueConstructor()) {
            sb.append(rdbAdaptor.tableAlias(qc.toSelectSql()));
        } else {
            String prefix = qc.getPrefix();
            StringBuilder sbJoin = new StringBuilder();
            if (prefix != null) {
                sbJoin.append(prefix).append(".");
            }
            sbJoin.append("OBJ_ID").append("=").append(mainTable).append(".").append("OBJ_ID");
            sbJoin.append(" AND ");
            if (prefix != null) {
                sbJoin.append(prefix).append(".");
            }
            sbJoin.append("OBJ_VER").append("=").append(mainTable).append(".").append("OBJ_VER");
            sb.append(rdbAdaptor.tableAlias(qc.toSelectSql(sbJoin.toString())));
        }
        sb.append(")");
        sb.append(" AND ").append(mainTable).append(".OBJ_DEF_VER<=").append(((MetaGRdbEntityStore)eh.getEntityStoreRuntime().getMetaData()).getVersion());
        return sb.toString();
    }

    private static class NeedOtherPageJoinChecker
    extends QueryVisitorSupport {
        private int myPageNo;
        private Set<Integer> otherPn;
        private EntityHandler eh;
        private EntityContext ec;

        private NeedOtherPageJoinChecker(int myPageNo, EntityHandler eh, EntityContext ec) {
            this.myPageNo = myPageNo;
            this.eh = eh;
            this.ec = ec;
        }

        Set<Integer> check(List<UpdateCondition.UpdateValue> values) {
            for (UpdateCondition.UpdateValue uv : values) {
                PropertyHandler pHandler = this.eh.getProperty(uv.getEntityField(), this.ec);
                if (!ObjStoreUpdateSql.canUpdateProperty(pHandler)) continue;
                GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)pHandler.getStoreSpecProperty());
                ValueExpression val = uv.getValue();
                List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                for (int i = 0; i < cols.size(); ++i) {
                    MetaGRdbPropertyStore.GRdbPropertyStoreHandler tcol = cols.get(i);
                    if (tcol.getMetaData().getPageNo() != this.myPageNo) continue;
                    val.accept(this);
                }
            }
            return this.otherPn;
        }

        @Override
        public boolean visit(EntityField entityField) {
            PropertyHandler ph = this.eh.getProperty(entityField.getPropertyName(), this.ec);
            if (ph == null) {
                throw new QueryException(entityField.getPropertyName() + " not define on" + this.eh.getMetaData().getName());
            }
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty());
            List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
            for (MetaGRdbPropertyStore.GRdbPropertyStoreHandler c : cols) {
                if (c.getMetaData().getPageNo() != this.myPageNo) {
                    if (this.otherPn == null) {
                        this.otherPn = new HashSet<Integer>();
                    }
                    this.otherPn.add(c.getMetaData().getPageNo());
                }
                if (c.isExternalIndex() || c.getIndexColName() == null || c.getMetaData().getIndexPageNo() == this.myPageNo) continue;
                if (this.otherPn == null) {
                    this.otherPn = new HashSet<Integer>();
                }
                this.otherPn.add(c.getMetaData().getIndexPageNo());
            }
            return false;
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            return false;
        }
    }

    private static class HasOtherPageChecker
    extends QueryVisitorSupport {
        private int myPageNo;
        private boolean hasOtherPage;
        private EntityHandler eh;
        private EntityContext ec;

        private HasOtherPageChecker(int myPageNo, EntityHandler eh, EntityContext ec) {
            this.myPageNo = myPageNo;
            this.eh = eh;
            this.ec = ec;
        }

        @Override
        public boolean visit(EntityField entityField) {
            if (!this.hasOtherPage) {
                PropertyHandler ph = this.eh.getProperty(entityField.getPropertyName(), this.ec);
                if (ph == null) {
                    throw new QueryException(entityField.getPropertyName() + " not define on" + this.eh.getMetaData().getName());
                }
                GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty());
                List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                for (MetaGRdbPropertyStore.GRdbPropertyStoreHandler c : cols) {
                    if (c.getMetaData().getPageNo() == this.myPageNo) continue;
                    this.hasOtherPage = true;
                    break;
                }
            }
            return false;
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            return false;
        }
    }
}

