/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff;

import java.sql.SQLException;
import java.sql.Statement;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.IndexDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.sql.IndexInsertSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.Diff;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class InsPropertyIndexType
extends Diff {
    private MetaPrimitiveProperty nextProperty;
    private MetaEntity nextEntity;

    public InsPropertyIndexType(MetaPrimitiveProperty nextProperty, MetaEntity nextEntity) {
        this.nextProperty = nextProperty;
        this.nextEntity = nextEntity;
    }

    @Override
    public void applyToData(Statement stmt, RdbAdapter rdb, int tenantId) throws SQLException {
        MetaGRdbPropertyStore propStore;
        if (this.needDataModify() && this.nextProperty.getEntityStoreProperty() instanceof MetaGRdbPropertyStore && (propStore = (MetaGRdbPropertyStore)this.nextProperty.getEntityStoreProperty()).isExternalIndex()) {
            BaseRdbTypeAdapter typeMapping = rdb.getRdbTypeAdapter(this.nextProperty.getType());
            IndexDeleteSql delSql = rdb.getUpdateSqlCreator(IndexDeleteSql.class);
            stmt.addBatch(delSql.deleteByColName(tenantId, this.nextEntity.getId(), ((MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition()).getTableNamePostfix(), propStore.getPageNo(), propStore.getColumnName(), typeMapping, this.nextProperty.getIndexType(), rdb));
            IndexInsertSql insSql = rdb.getUpdateSqlCreator(IndexInsertSql.class);
            stmt.addBatch(insSql.insertAll(tenantId, this.nextEntity.getId(), ((MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition()).getTableNamePostfix(), propStore.getPageNo(), propStore.getColumnName(), this.nextProperty.getIndexType(), typeMapping, rdb));
            stmt.executeBatch();
        }
    }

    @Override
    public void modifyMetaData() {
    }

    @Override
    public boolean needDataModify() {
        return this.nextProperty.getIndexType() != null && this.nextProperty.getIndexType() != IndexType.NON_INDEXED;
    }
}

