/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

public class EntityBuilder {
    private EntityHandler eh;
    private boolean isMulti;
    private int oidIndex = -1;
    private int versionIndex = -1;
    private List<Object[]> primitives = new ArrayList<Object[]>();
    private List<Object[]> references;
    private Map<String, Entity> entities = new LinkedHashMap<String, Entity>();

    public EntityBuilder(EntityHandler eh, EntityContext context, List<ValueExpression> selectValues) {
        this(eh, context, EntityBuilder.toProps(selectValues));
    }

    private static String[] toProps(List<ValueExpression> selectValues) {
        String[] properties = new String[selectValues.size()];
        for (int i = 0; i < selectValues.size(); ++i) {
            ValueExpression v = selectValues.get(i);
            if (!(v instanceof EntityField)) continue;
            properties[i] = ((EntityField)v).getPropertyName();
        }
        return properties;
    }

    public EntityBuilder(EntityHandler eh, EntityContext context, String[] properties) {
        this.eh = eh;
        HashMap<String, String[]> subRefs = null;
        for (int i = 0; i < properties.length; ++i) {
            String refName;
            String[] subProps;
            String p = properties[i];
            if (p == null) continue;
            int index = p.indexOf(46);
            if (index < 0) {
                if (this.oidIndex == -1 && p.equals("oid")) {
                    this.oidIndex = i;
                }
                if (this.versionIndex == -1 && eh.isVersioned() && p.equals("version")) {
                    this.versionIndex = i;
                }
                this.primitives.add(new Object[]{p, i});
                continue;
            }
            if (subRefs == null) {
                subRefs = new HashMap<String, String[]>();
            }
            if ((subProps = (String[])subRefs.get(refName = p.substring(0, index))) == null) {
                subProps = new String[properties.length];
                subRefs.put(refName, subProps);
            }
            subProps[i] = p.substring(index + 1);
        }
        if (subRefs != null) {
            this.references = new ArrayList<Object[]>();
            for (Map.Entry e : subRefs.entrySet()) {
                ReferencePropertyHandler rp = (ReferencePropertyHandler)eh.getDeclaredProperty((String)e.getKey());
                EntityHandler subEh = rp.getReferenceEntityHandler(context);
                EntityBuilder eb = new EntityBuilder(subEh, context, (String[])e.getValue());
                if (rp.getMetaData().getMultiplicity() == -1 || rp.getMetaData().getMultiplicity() > 1) {
                    eb.isMulti = true;
                }
                this.references.add(new Object[]{e.getKey(), eb});
            }
        }
    }

    public Collection<Entity> getCollection() {
        return this.entities.values();
    }

    public void finished() {
        if (this.references != null && this.references.size() > 0) {
            for (Object[] nameAndBuilder : this.references) {
                EntityBuilder eb = (EntityBuilder)nameAndBuilder[1];
                if (eb.isMulti) {
                    for (Entity e : this.entities.values()) {
                        List el = (List)e.getValue((String)nameAndBuilder[0]);
                        if (el == null) continue;
                        e.setValue((String)nameAndBuilder[0], el.toArray(eb.eh.newArrayInstance(el.size())));
                    }
                }
                eb.finished();
            }
        }
    }

    public Entity handle(Object[] datas) {
        if (datas[this.oidIndex] == null) {
            return null;
        }
        String key = this.versionIndex == -1 ? (String)datas[this.oidIndex] : datas[this.oidIndex] + "-" + datas[this.versionIndex];
        boolean isNew = false;
        Entity e = this.entities.get(key);
        if (e == null) {
            isNew = true;
            e = this.eh.newInstance();
            if (this.primitives != null) {
                for (Object[] nameAndIndex : this.primitives) {
                    e.setValue((String)nameAndIndex[0], datas[(Integer)nameAndIndex[1]]);
                }
            }
            this.entities.put(key, e);
        }
        if (this.references != null) {
            for (Object[] nameAndBuilder : this.references) {
                EntityBuilder eb = (EntityBuilder)nameAndBuilder[1];
                Entity ref = eb.handle(datas);
                if (ref == null) continue;
                if (!eb.isMulti) {
                    e.setValue((String)nameAndBuilder[0], ref);
                    continue;
                }
                LinkedList<Entity> el = (LinkedList<Entity>)e.getValue((String)nameAndBuilder[0]);
                if (el == null) {
                    el = new LinkedList<Entity>();
                    e.setValue((String)nameAndBuilder[0], el);
                }
                el.add(ref);
            }
        }
        if (isNew) {
            return e;
        }
        return null;
    }
}

