/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.csv;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.EntityMapping;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class EntityCsvReader
implements Iterable<Entity>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EntityCsvReader.class);
    public static final String CTRL_CODE_KEY = "_useCtrl";
    public static final String CTRL_INSERT = "I";
    public static final String CTRL_UPDATE = "U";
    public static final String CTRL_DELETE = "D";
    public static final String CTRL_MERGE = "M";
    public static final int NVL = -1;
    private EntityDefinition definition;
    private boolean withReferenceVersion;
    private Reader reader;
    private CsvListReader csvListReader;
    private List<String> header;
    private List<String> properties;
    private List<Integer> arrayIndex;
    private Map<String, ReferenceInfo> references;
    private boolean isInit;
    private boolean isIterate;
    private boolean useCtrl;
    private ObjectMapper mapper;
    private EntityDefinitionManager edm = ManagerLocator.manager(EntityDefinitionManager.class);
    private EntityManager em = ManagerLocator.manager(EntityManager.class);

    public EntityCsvReader(EntityDefinition definition, InputStream inputStream, boolean withReferenceVersion) throws UnsupportedEncodingException {
        this(definition, inputStream, "UTF-8", withReferenceVersion);
    }

    public EntityCsvReader(EntityDefinition definition, InputStream inputStream, String charset, boolean withReferenceVersion) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        this.definition = definition;
        this.reader = new BufferedReader(reader);
        this.withReferenceVersion = withReferenceVersion;
    }

    public EntityCsvReader(EntityDefinition definition, Reader reader, boolean withReferenceVersion) {
        this.definition = definition;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.withReferenceVersion = withReferenceVersion;
    }

    protected void init() {
        if (this.isInit) {
            return;
        }
        this.csvListReader = new CsvListReader(this.reader, new CsvPreference.Builder(CsvPreference.STANDARD_PREFERENCE).surroundingSpacesNeedQuotes(true).build());
        List headerLine = null;
        try {
            headerLine = this.csvListReader.read();
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
        if (headerLine == null) {
            throw new EntityCsvException("CE2000", EntityCsvReader.rs("impl.csv.EntityCsvReader.emptyFile", new Object[0]));
        }
        this.readHeader(headerLine);
        this.validateHeader();
        this.isInit = true;
    }

    public boolean isUseCtrl() {
        this.init();
        return this.useCtrl;
    }

    public List<String> properties() {
        this.init();
        return this.properties;
    }

    @Override
    public Iterator<Entity> iterator() {
        this.init();
        if (this.isIterate) {
            throw new UnsupportedOperationException("concurrent iterate not supported.");
        }
        this.isIterate = true;
        return new Iterator<Entity>(){
            private List<String> currentLine;

            @Override
            public boolean hasNext() {
                this.read();
                return this.currentLine != null;
            }

            private void read() {
                if (this.currentLine == null) {
                    try {
                        this.currentLine = EntityCsvReader.this.csvListReader.read();
                    }
                    catch (IOException e) {
                        throw new EntityCsvException(e);
                    }
                }
            }

            @Override
            public Entity next() {
                this.read();
                if (this.currentLine == null) {
                    throw new NoSuchElementException();
                }
                EntityCsvReader.this.validateLine(this.currentLine);
                EntityMapping mapping = EntityCsvReader.this.definition.getMapping();
                Entity entity = EntityCsvReader.this.generateEntity(mapping, null);
                entity.setDefinitionName(EntityCsvReader.this.definition.getName());
                HashSet<String> multiProp = new HashSet<String>();
                for (int i = 0; i < EntityCsvReader.this.header.size(); ++i) {
                    String headerName = (String)EntityCsvReader.this.header.get(i);
                    if (headerName.equals("updateBy") || headerName.equals("updateDate") || headerName.equals("lockedBy") || headerName.equals("createBy") || headerName.equals("createDate")) continue;
                    String value = this.currentLine.get(i);
                    if (i == 0 && headerName.equals(EntityCsvReader.CTRL_CODE_KEY)) {
                        entity.setValue(EntityCsvReader.CTRL_CODE_KEY, value);
                        continue;
                    }
                    try {
                        String propName = headerName;
                        Object propValue = null;
                        if (headerName.contains(".")) {
                            propName = ((ReferenceInfo)EntityCsvReader.this.references.get(headerName)).propName;
                            propValue = ((ReferenceInfo)EntityCsvReader.this.references.get(headerName)).convEntity(value);
                        } else {
                            propValue = EntityCsvReader.this.conv(value, headerName, EntityCsvReader.this.definition.getProperty(propName));
                        }
                        if ((Integer)EntityCsvReader.this.arrayIndex.get(i) == -1) {
                            entity.setValue(propName, propValue);
                            continue;
                        }
                        Object[] valArray = (Object[])entity.getValue(propName);
                        if (valArray == null) {
                            valArray = (Object[])Array.newInstance(EntityCsvReader.this.definition.getProperty(propName).getJavaType(), EntityCsvReader.this.definition.getProperty(propName).getMultiplicity());
                            entity.setValue(propName, valArray);
                            multiProp.add(propName);
                        }
                        valArray[((Integer)((EntityCsvReader)EntityCsvReader.this).arrayIndex.get((int)i)).intValue()] = propValue;
                        continue;
                    }
                    catch (Exception e) {
                        throw new EntityCsvException("CE1001", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidValue", new Object[]{headerName, value}), e);
                    }
                }
                EntityCsvReader.this.trimMultipleValue(entity, multiProp);
                this.currentLine = null;
                return entity;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        Object closable;
        Object object = closable = this.csvListReader != null ? this.csvListReader : this.reader;
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                logger.warn("fail to close EntityCsvReader resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.csvListReader = null;
            this.reader = null;
        }
    }

    protected List<String> header() {
        this.init();
        return this.header;
    }

    protected List<String> readLine() throws IOException {
        this.init();
        return this.csvListReader.read();
    }

    protected void validateLine(List<String> line) {
        this.init();
        if (line.size() != this.header.size()) {
            throw new EntityCsvException("CE2006", EntityCsvReader.rs("impl.csv.EntityCsvReader.mismatchHeadSize", this.header.size(), line.size()));
        }
    }

    protected void validateValue(String headerName, String value) {
        this.init();
        try {
            if (headerName.equals("updateBy") || headerName.equals("updateDate") || headerName.equals("lockedBy") || headerName.equals("createBy") || headerName.equals("createDate")) {
                return;
            }
            if (headerName.contains(".")) {
                this.conv(value, headerName, this.references.get(headerName).unique);
            } else {
                this.conv(value, headerName, this.definition.getProperty(headerName));
            }
        }
        catch (Exception e) {
            throw new EntityCsvException("CE1001", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidValue", headerName, value), e);
        }
    }

    private void readHeader(List<String> headerLine) {
        this.header = new ArrayList<String>(headerLine.size());
        this.arrayIndex = new ArrayList<Integer>(headerLine.size());
        this.properties = new ArrayList<String>(headerLine.size());
        for (int i = 0; i < headerLine.size(); ++i) {
            String headerValue = headerLine.get(i);
            if (StringUtil.isEmpty(headerValue)) {
                throw new EntityCsvException("CE2001", EntityCsvReader.rs("impl.csv.EntityCsvReader.emptyHead", i + 1));
            }
            String headerName = headerValue.split("\\(")[0];
            int index = -1;
            if (headerName.contains("[")) {
                try {
                    index = Integer.parseInt(headerName.substring(headerName.indexOf(91) + 1, headerName.lastIndexOf(93)));
                }
                catch (NumberFormatException e) {
                    throw new EntityCsvException("CE2002", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadIndex", i + 1, headerValue));
                }
                headerName = headerName.substring(0, headerName.indexOf(91));
            }
            this.header.add(headerName);
            this.arrayIndex.add(index);
            String propName = headerName;
            if (headerName.contains(".")) {
                propName = headerName.substring(0, headerName.indexOf("."));
            }
            this.properties.add(propName);
        }
        if (this.header.size() > 0 && this.header.get(0).charAt(0) == '\ufeff') {
            this.header.set(0, String.copyValueOf(this.header.get(0).toCharArray(), 1, this.header.get(0).toCharArray().length - 1));
        }
        if (this.properties.size() > 0 && this.properties.get(0).charAt(0) == '\ufeff') {
            this.properties.set(0, String.copyValueOf(this.properties.get(0).toCharArray(), 1, this.properties.get(0).toCharArray().length - 1));
        }
    }

    private void validateHeader() {
        for (int i = 0; i < this.header.size(); ++i) {
            String headerName = this.header.get(i);
            if (i == 0 && CTRL_CODE_KEY.equals(headerName)) {
                this.useCtrl = true;
                continue;
            }
            PropertyDefinition pd = null;
            ReferenceInfo reference = null;
            if (headerName.contains(".")) {
                String propName = this.properties.get(i);
                String uniqueKey = headerName.substring(propName.length() + 1);
                ReferenceProperty rp = (ReferenceProperty)this.definition.getProperty(propName);
                if (rp == null) {
                    throw new EntityCsvException("CE2003", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                }
                EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
                if (red == null) {
                    throw new EntityCsvException("CE2003", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                }
                PropertyDefinition unique = red.getProperty(uniqueKey);
                if (unique == null) {
                    throw new EntityCsvException("CE2003", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                }
                reference = new ReferenceInfo(propName, red, unique);
                pd = rp;
            } else {
                pd = this.definition.getProperty(headerName);
                if (pd == null) {
                    throw new EntityCsvException("CE2003", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                }
                if (pd instanceof ReferenceProperty) {
                    EntityDefinition red = this.edm.get(((ReferenceProperty)pd).getObjectDefinitionName());
                    if (red == null) {
                        throw new EntityCsvException("CE2003", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                    }
                    reference = new ReferenceInfo(headerName, red, null);
                }
            }
            if (pd instanceof ReferenceProperty) {
                if (this.arrayIndex.get(i) != -1) {
                    throw new EntityCsvException("CE2003", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadRefProp", i + 1, headerName));
                }
            } else if (pd.getMultiplicity() == 1) {
                if (this.arrayIndex.get(i) != -1) {
                    throw new EntityCsvException("CE2004", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadSingleProp", i + 1, headerName));
                }
            } else if (this.arrayIndex.get(i) == -1) {
                throw new EntityCsvException("CE2005", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidHeadMultiProp", i + 1, headerName));
            }
            if (reference == null) continue;
            if (this.references == null) {
                this.references = new HashMap<String, ReferenceInfo>();
            }
            this.references.put(headerName, reference);
        }
    }

    private Object conv(String valStr, String headerName, PropertyDefinition pd) {
        if (pd instanceof BinaryProperty) {
            if (StringUtil.isEmpty(valStr)) {
                return null;
            }
            BinaryReference br = null;
            try {
                JsonNode root;
                JsonNode lobidNode;
                if (this.mapper == null) {
                    this.mapper = new ObjectMapper();
                }
                if ((lobidNode = (root = (JsonNode)this.mapper.readValue(valStr, JsonNode.class)).get("lobid")) != null) {
                    JsonNode typeNode;
                    br = new BinaryReference();
                    br.setLobId(Long.parseLong(lobidNode.asText()));
                    JsonNode nameNode = root.get("name");
                    if (nameNode != null) {
                        br.setName(nameNode.asText());
                    }
                    if ((typeNode = root.get("type")) != null) {
                        br.setType(typeNode.asText());
                    }
                }
            }
            catch (IOException e) {
                throw new EntityCsvException("fail to create binary value. value:" + valStr);
            }
            return br;
        }
        if (pd instanceof BooleanProperty) {
            if (StringUtil.isEmpty(valStr)) {
                return null;
            }
            if (valStr.equals("1") || valStr.equalsIgnoreCase("true") || valStr.equalsIgnoreCase("t") || valStr.equalsIgnoreCase("yes") || valStr.equalsIgnoreCase("y")) {
                return Boolean.TRUE;
            }
            if (valStr.trim().length() == 0 || valStr.equals("0") || valStr.equalsIgnoreCase("false") || valStr.equalsIgnoreCase("f") || valStr.equalsIgnoreCase("no") || valStr.equalsIgnoreCase("n")) {
                return Boolean.FALSE;
            }
        } else {
            if (pd instanceof DateProperty) {
                return ConvertUtil.convertFromString(Date.class, valStr);
            }
            if (pd instanceof DateTimeProperty) {
                return ConvertUtil.convertFromString(Timestamp.class, valStr);
            }
            if (pd instanceof DecimalProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return new BigDecimal(valStr);
            }
            if (pd instanceof ExpressionProperty) {
                return null;
            }
            if (pd instanceof FloatProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return Double.parseDouble(valStr);
            }
            if (pd instanceof IntegerProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return Long.parseLong(valStr);
            }
            if (pd instanceof LongTextProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return valStr;
            }
            if (pd instanceof ReferenceProperty) {
                String[] oidList;
                ReferenceProperty rpd = (ReferenceProperty)pd;
                ReferenceInfo reference = this.references.get(headerName);
                if (rpd.getMultiplicity() == 1) {
                    if (StringUtil.isEmpty(valStr)) {
                        return null;
                    }
                    Entity entity = this.generateReferenceEntity(valStr, rpd, reference.ed);
                    return entity;
                }
                if (StringUtil.isEmpty(valStr)) {
                    return new Entity[0];
                }
                ArrayList<Entity> eList = new ArrayList<Entity>();
                for (String oid : oidList = valStr.split(",")) {
                    if ((oid = oid.trim()).length() == 0) continue;
                    eList.add(this.generateReferenceEntity(oid, rpd, reference.ed));
                }
                if (reference.ed.getMapping() != null && reference.ed.getMapping().getMappingModelClass() != null) {
                    String className = reference.ed.getMapping().getMappingModelClass();
                    try {
                        Object[] hoge = (Object[])Array.newInstance(Class.forName(className).newInstance().getClass(), eList.size());
                        return eList.toArray(hoge);
                    }
                    catch (Exception e) {
                        throw new EntityCsvException("CE2008", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidRefJavaMappingClass", rpd.getName(), className), e);
                    }
                }
                return eList.toArray(new Entity[eList.size()]);
            }
            if (pd instanceof SelectProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                SelectProperty selectDef = (SelectProperty)pd;
                for (SelectValue sv : selectDef.getSelectValueList()) {
                    if (!valStr.equals(sv.getValue())) continue;
                    return sv;
                }
            } else {
                if (pd instanceof StringProperty) {
                    if (StringUtil.isEmpty(valStr)) {
                        return null;
                    }
                    return valStr;
                }
                if (pd instanceof TimeProperty) {
                    return ConvertUtil.convertFromString(Time.class, valStr);
                }
                if (pd instanceof AutoNumberProperty) {
                    if (StringUtil.isEmpty(valStr)) {
                        return null;
                    }
                    return valStr;
                }
            }
        }
        throw new EntityCsvException("CE2007", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidValueType", pd.getName(), pd.getClass().getName(), valStr));
    }

    private Entity generateEntity(EntityMapping mapping, String propName) {
        Entity entity = null;
        if (mapping != null) {
            try {
                entity = (Entity)Class.forName(mapping.getMappingModelClass()).newInstance();
            }
            catch (Exception e) {
                if (propName == null) {
                    throw new EntityCsvException("CE2008", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidJavaMappingClass", mapping.getMappingModelClass()), e);
                }
                throw new EntityCsvException("CE2008", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidRefJavaMappingClass", propName, mapping.getMappingModelClass()), e);
            }
        } else {
            entity = new GenericEntity();
        }
        return entity;
    }

    private Entity generateReferenceEntity(String value, ReferenceProperty rpd, EntityDefinition red) {
        String ver;
        String oid;
        Entity entity = this.generateEntity(red.getMapping(), rpd.getName());
        entity.setDefinitionName(red.getName());
        if (!this.withReferenceVersion && red != null && red.getVersionControlType() == VersionControlType.NONE) {
            oid = value;
            ver = "0";
        } else if (value.lastIndexOf(46) > 0) {
            oid = value.substring(0, value.lastIndexOf(46));
            ver = value.substring(value.lastIndexOf(46) + 1);
        } else {
            oid = value;
            ver = "0";
        }
        entity.setOid(oid);
        entity.setVersion(Long.parseLong(ver));
        return entity;
    }

    private void trimMultipleValue(Entity entity, Set<String> multiProperty) {
        for (String propName : multiProperty) {
            Object[] valArray = (Object[])entity.getValue(propName);
            if (valArray == null) continue;
            int lastIndex = -1;
            for (int i = valArray.length - 1; i >= 0; --i) {
                if (valArray[i] == null) continue;
                lastIndex = i;
                break;
            }
            if (lastIndex < 0) {
                entity.setValue(propName, null);
                continue;
            }
            if (lastIndex == valArray.length - 1) continue;
            entity.setValue(propName, Arrays.copyOf(valArray, lastIndex + 1));
        }
    }

    private static String rs(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    private class ReferenceInfo {
        private String propName;
        private EntityDefinition ed;
        private PropertyDefinition unique;
        private Query uniqueQuery;

        public ReferenceInfo(String propName, EntityDefinition ed, PropertyDefinition unique) {
            this.propName = propName;
            this.ed = ed;
            this.unique = unique;
        }

        public Object convEntity(String value) {
            String[] uniqueList;
            ReferenceProperty rp = (ReferenceProperty)EntityCsvReader.this.definition.getProperty(this.propName);
            if (rp.getMultiplicity() == 1) {
                if (StringUtil.isEmpty(value)) {
                    return null;
                }
                Object uniqueValue = EntityCsvReader.this.conv(value, null, this.unique);
                if (uniqueValue != null) {
                    return this.search(uniqueValue);
                }
                return null;
            }
            if (StringUtil.isEmpty(value)) {
                return new Entity[0];
            }
            ArrayList<Entity> eList = new ArrayList<Entity>();
            for (String uniqueStr : uniqueList = value.split(",")) {
                Entity ref;
                Object uniqueValue;
                if ((uniqueStr = uniqueStr.trim()).length() == 0 || (uniqueValue = EntityCsvReader.this.conv(uniqueStr, null, this.unique)) == null || (ref = this.search(uniqueValue)) == null) continue;
                eList.add(ref);
            }
            if (this.ed.getMapping() != null && this.ed.getMapping().getMappingModelClass() != null) {
                String className = this.ed.getMapping().getMappingModelClass();
                try {
                    Object[] hoge = (Object[])Array.newInstance(Class.forName(className).newInstance().getClass(), eList.size());
                    return eList.toArray(hoge);
                }
                catch (Exception e) {
                    throw new EntityCsvException("CE2008", EntityCsvReader.rs("impl.csv.EntityCsvReader.invalidRefJavaMappingClass", new Object[]{this.propName, className}), e);
                }
            }
            return eList.toArray(new Entity[eList.size()]);
        }

        private Entity search(Object uniqueValue) {
            if (this.uniqueQuery == null) {
                this.uniqueQuery = new Query().select("oid", "version").from(this.ed.getName());
            }
            Query query = this.uniqueQuery.copy().where(new Equals(this.unique.getName(), uniqueValue));
            return (Entity)EntityCsvReader.this.em.searchEntity(query).getFirst();
        }
    }
}

