/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.entity.jaxb.JaxbProperty;

public class EntityPropertyXmlAdapter
extends XmlAdapter<JaxbProperty[], Map<String, Object>> {
    public Map<String, Object> unmarshal(JaxbProperty[] v) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (JaxbProperty p : v) {
            if (p.value == null) continue;
            props.put(p.name, p.value);
        }
        if (props.size() == 0) {
            return null;
        }
        return props;
    }

    public JaxbProperty[] marshal(Map<String, Object> v) throws Exception {
        ArrayList<JaxbProperty> property = new ArrayList<JaxbProperty>();
        for (Map.Entry<String, Object> e : v.entrySet()) {
            Object val = e.getValue();
            if (val == null) continue;
            JaxbProperty p = new JaxbProperty();
            p.name = e.getKey();
            if (val instanceof Entity[]) {
                if (val.getClass() == GenericEntity[].class) {
                    p.value = val;
                } else {
                    Entity[] src = (Entity[])val;
                    GenericEntity[] dest = new GenericEntity[src.length];
                    System.arraycopy(src, 0, dest, 0, src.length);
                    p.value = dest;
                }
            } else {
                p.value = val;
            }
            property.add(p);
        }
        return property.toArray(new JaxbProperty[property.size()]);
    }
}

