/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.definition.EventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.EventType;
import org.iplass.mtp.entity.definition.listeners.SendNotificationEventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.SendNotificationType;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaEventListener;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.MailManager;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationManager;
import org.iplass.mtp.sms.SmsMail;
import org.iplass.mtp.sms.SmsMailManager;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSendNotificationEventListener
extends MetaEventListener {
    private static final long serialVersionUID = 3089787592456473699L;
    private static final Logger fatalLog = LoggerFactory.getLogger((String)"mtp.fatal.mail");
    public static final String TENANT_BINDING_NAME = "tenant";
    public static final String ENTITY_BINDING_NAME = "entity";
    public static final String EVENT_TYPE_BINDING_NAME = "event";
    public static final String CONTEXT_BINDING_NAME = "context";
    public static final String USER_BINDING_NAME = "user";
    public static final String DATE_BINGING_NAME = "date";
    private SendNotificationType notificationType;
    private String tmplDefName;
    private String notificationCondScript;
    private List<EventType> listenEvent;

    public SendNotificationType getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(SendNotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public String getTmplDefName() {
        return this.tmplDefName;
    }

    public void setTmplDefName(String tmplDefName) {
        this.tmplDefName = tmplDefName;
    }

    public String getNotificationCondScript() {
        return this.notificationCondScript;
    }

    public void setNotificationCondScript(String notificationCondScript) {
        this.notificationCondScript = notificationCondScript;
    }

    public List<EventType> getListenEvent() {
        return this.listenEvent;
    }

    public void setListenEvent(List<EventType> listenEvent) {
        this.listenEvent = listenEvent;
    }

    @Override
    public MetaEventListener copy() {
        MetaSendNotificationEventListener copy = new MetaSendNotificationEventListener();
        this.copyTo(copy);
        copy.notificationType = this.notificationType;
        copy.tmplDefName = this.tmplDefName;
        copy.notificationCondScript = this.notificationCondScript;
        if (this.listenEvent != null) {
            copy.listenEvent = new ArrayList<EventType>();
            copy.listenEvent.addAll(this.listenEvent);
        }
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.listenEvent == null ? 0 : this.listenEvent.hashCode());
        result = 31 * result + (this.notificationCondScript == null ? 0 : this.notificationCondScript.hashCode());
        result = 31 * result + (this.notificationType == null ? 0 : this.notificationType.hashCode());
        result = 31 * result + (this.tmplDefName == null ? 0 : this.tmplDefName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaSendNotificationEventListener other = (MetaSendNotificationEventListener)obj;
        if (this.listenEvent == null ? other.listenEvent != null : !this.listenEvent.equals(other.listenEvent)) {
            return false;
        }
        if (this.notificationCondScript == null ? other.notificationCondScript != null : !this.notificationCondScript.equals(other.notificationCondScript)) {
            return false;
        }
        if (this.notificationType != other.notificationType) {
            return false;
        }
        return !(this.tmplDefName == null ? other.tmplDefName != null : !this.tmplDefName.equals(other.tmplDefName));
    }

    @Override
    public void applyConfig(EventListenerDefinition def) {
        this.fillFrom(def);
        SendNotificationEventListenerDefinition d = (SendNotificationEventListenerDefinition)def;
        this.notificationType = d.getNotificationType();
        this.tmplDefName = d.getTmplDefName();
        this.notificationCondScript = d.getNotificationCondScript();
        if (d.getListenEvent() != null) {
            this.listenEvent = new ArrayList<EventType>();
            this.listenEvent.addAll(d.getListenEvent());
        } else {
            this.listenEvent = null;
        }
    }

    @Override
    public EventListenerDefinition currentConfig() {
        SendNotificationEventListenerDefinition d = new SendNotificationEventListenerDefinition();
        this.fillTo(d);
        d.setNotificationType(this.notificationType);
        d.setTmplDefName(this.tmplDefName);
        d.setNotificationCondScript(this.notificationCondScript);
        if (this.listenEvent != null) {
            ArrayList<EventType> es = new ArrayList<EventType>();
            es.addAll(this.listenEvent);
            d.setListenEvent(es);
        }
        return d;
    }

    @Override
    public MetaEventListener.EventListenerRuntime createRuntime(MetaEntity entity) {
        if (this.notificationType == SendNotificationType.MAIL) {
            return new SendMailNotificationEventListenerHandler(entity);
        }
        if (this.notificationType == SendNotificationType.SMS) {
            return new SendSMSNotificationEventListenerHandler(entity);
        }
        if (this.notificationType == SendNotificationType.PUSH) {
            return new SendPushNotificationEventListenerHandler(entity);
        }
        return null;
    }

    public class SendPushNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private PushNotificationManager pm;

        public SendPushNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.pm = ManagerLocator.getInstance().getManager(PushNotificationManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            return this.pm.createNotification(MetaSendNotificationEventListener.this.tmplDefName, bindings);
        }

        @Override
        protected void sendNotification(Object mail) {
            this.pm.push((PushNotification)mail);
        }
    }

    public class SendSMSNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private SmsMailManager smm;

        public SendSMSNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.smm = ManagerLocator.getInstance().getManager(SmsMailManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            return this.smm.createMail(MetaSendNotificationEventListener.this.tmplDefName, bindings);
        }

        @Override
        protected void sendNotification(Object mail) {
            this.smm.sendMail((SmsMail)mail);
        }
    }

    public class SendMailNotificationEventListenerHandler
    extends SendNotificationListenerEventHandler {
        private MailManager mm;

        public SendMailNotificationEventListenerHandler(MetaEntity entity) {
            super(entity);
            this.mm = ManagerLocator.getInstance().getManager(MailManager.class);
        }

        @Override
        protected Object createNotification(Entity entity, EventType type, EntityEventContext context) {
            Map<String, Object> bindings = this.generateBindings(entity, type, context);
            return this.mm.createMail(MetaSendNotificationEventListener.this.tmplDefName, bindings);
        }

        @Override
        protected void sendNotification(Object mail) {
            this.mm.sendMail((Mail)mail);
        }
    }

    private abstract class SendNotificationListenerEventHandler
    extends MetaEventListener.EventListenerRuntime {
        private static final String SCRIPT_PREFIX = "SendNotificationListenerEventHandler_notificationCondScript";
        private Script compiledScript;
        private ScriptEngine scriptEngine;
        private boolean isNotifyAfterDelete;
        private boolean isNotifyAfterInsert;
        private boolean isNotifyAfterUpdate;
        private boolean isNotifyBeforeDelete;
        private boolean isNotifyBeforeInsert;
        private boolean isNotifyBeforeUpdate;
        private boolean isNotifyBeforeValidate;
        private boolean isNotifyOnLoad;
        private boolean isNotifyAfterRestore;
        private boolean isNotifyAfterPurge;

        public SendNotificationListenerEventHandler(MetaEntity entity) {
            super(MetaSendNotificationEventListener.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            if (StringUtil.isNotEmpty(MetaSendNotificationEventListener.this.notificationCondScript)) {
                String scriptWithImport = "import " + EventType.class.getName() + ";\n" + MetaSendNotificationEventListener.this.notificationCondScript;
                String scriptName = null;
                for (int i = 0; i < entity.getEventListenerList().size(); ++i) {
                    if (MetaSendNotificationEventListener.this != entity.getEventListenerList().get(i)) continue;
                    scriptName = "SendNotificationListenerEventHandler_notificationCondScript_" + entity.getId() + "_" + i;
                    break;
                }
                this.compiledScript = this.scriptEngine.createScript(scriptWithImport, scriptName);
            }
            if (MetaSendNotificationEventListener.this.listenEvent != null) {
                for (EventType eType : MetaSendNotificationEventListener.this.listenEvent) {
                    switch (eType) {
                        case AFTER_DELETE: {
                            this.isNotifyAfterDelete = true;
                            break;
                        }
                        case AFTER_INSERT: {
                            this.isNotifyAfterInsert = true;
                            break;
                        }
                        case AFTER_UPDATE: {
                            this.isNotifyAfterUpdate = true;
                            break;
                        }
                        case BEFORE_DELETE: {
                            this.isNotifyBeforeDelete = true;
                            break;
                        }
                        case BEFORE_INSERT: {
                            this.isNotifyBeforeInsert = true;
                            break;
                        }
                        case BEFORE_UPDATE: {
                            this.isNotifyBeforeUpdate = true;
                            break;
                        }
                        case BEFORE_VALIDATE: {
                            this.isNotifyBeforeValidate = true;
                            break;
                        }
                        case ON_LOAD: {
                            this.isNotifyOnLoad = true;
                            break;
                        }
                        case AFTER_RESTORE: {
                            this.isNotifyAfterRestore = true;
                            break;
                        }
                        case AFTER_PURGE: {
                            this.isNotifyAfterPurge = true;
                        }
                    }
                }
            }
        }

        private void setupHandleAfterCommit(Entity entity, EventType type, EntityEventContext context) {
            Transaction t = ManagerLocator.getInstance().getManager(TransactionManager.class).currentTransaction();
            Object n = this.createNotification(entity, type, context);
            if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
                t.afterCommit(() -> {
                    try {
                        this.sendNotification(n);
                    }
                    catch (RuntimeException e) {
                        fatalLog.error("cannot send notification:entity=" + entity + ",event=" + (Object)((Object)type) + ",context=" + context + ",templateName=" + MetaSendNotificationEventListener.this.tmplDefName, (Throwable)e);
                    }
                });
            } else {
                this.sendNotification(n);
            }
        }

        private boolean callScript(Entity entity, EventType type, EntityEventContext context) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute(MetaSendNotificationEventListener.ENTITY_BINDING_NAME, entity);
            sc.setAttribute(MetaSendNotificationEventListener.EVENT_TYPE_BINDING_NAME, (Object)type);
            sc.setAttribute(MetaSendNotificationEventListener.CONTEXT_BINDING_NAME, context);
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            sc.setAttribute(MetaSendNotificationEventListener.USER_BINDING_NAME, AuthContextHolder.getAuthContext().newUserBinding());
            sc.setAttribute(MetaSendNotificationEventListener.DATE_BINGING_NAME, ex.getCurrentTimestamp());
            Object val = this.compiledScript.eval(sc);
            if (val != null) {
                if (val instanceof Boolean) {
                    return (Boolean)val;
                }
                if (val instanceof String) {
                    return Boolean.parseBoolean((String)val);
                }
            }
            return false;
        }

        protected abstract Object createNotification(Entity var1, EventType var2, EntityEventContext var3);

        protected abstract void sendNotification(Object var1);

        @Override
        public void handleAfterDelete(Entity entity, EntityEventContext context) {
            if (this.isNotifyAfterDelete && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_DELETE, context))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_DELETE, context);
            }
        }

        @Override
        public void handleAfterInsert(Entity entity, EntityEventContext context) {
            if (this.isNotifyAfterInsert && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_INSERT, context))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_INSERT, context);
            }
        }

        @Override
        public void handleAfterUpdate(Entity entity, EntityEventContext context) {
            if (this.isNotifyAfterUpdate && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_UPDATE, context))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_UPDATE, context);
            }
        }

        @Override
        public boolean handleBeforeDelete(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeDelete && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_DELETE, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_DELETE, context);
            }
            return true;
        }

        @Override
        public boolean handleBeforeInsert(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeInsert && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_INSERT, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_INSERT, context);
            }
            return true;
        }

        @Override
        public boolean handleBeforeUpdate(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeUpdate && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_UPDATE, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_UPDATE, context);
            }
            return true;
        }

        @Override
        public void handleOnLoad(Entity entity) {
            if (this.isNotifyOnLoad && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.ON_LOAD, null))) {
                this.setupHandleAfterCommit(entity, EventType.ON_LOAD, null);
            }
        }

        @Override
        public void handleBeforeValidate(Entity entity, EntityEventContext context) {
            if (this.isNotifyBeforeValidate && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.BEFORE_VALIDATE, context))) {
                this.setupHandleAfterCommit(entity, EventType.BEFORE_VALIDATE, context);
            }
        }

        @Override
        public void handleAfterRestore(Entity entity) {
            if (this.isNotifyAfterRestore && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_RESTORE, null))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_RESTORE, null);
            }
        }

        @Override
        public void handleAfterPurge(Entity entity) {
            if (this.isNotifyAfterPurge && (StringUtil.isEmpty(MetaSendNotificationEventListener.this.notificationCondScript) || this.callScript(entity, EventType.AFTER_PURGE, null))) {
                this.setupHandleAfterCommit(entity, EventType.AFTER_PURGE, null);
            }
        }

        @Override
        public MetaSendNotificationEventListener getMetaData() {
            return MetaSendNotificationEventListener.this;
        }

        protected Map<String, Object> generateBindings(Entity entity, EventType type, EntityEventContext context) {
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put(MetaSendNotificationEventListener.TENANT_BINDING_NAME, ex.getCurrentTenant());
            bindings.put(MetaSendNotificationEventListener.ENTITY_BINDING_NAME, entity);
            bindings.put(MetaSendNotificationEventListener.EVENT_TYPE_BINDING_NAME, (Object)type);
            bindings.put(MetaSendNotificationEventListener.CONTEXT_BINDING_NAME, context);
            bindings.put(MetaSendNotificationEventListener.USER_BINDING_NAME, AuthContextHolder.getAuthContext().newUserBinding());
            bindings.put(MetaSendNotificationEventListener.DATE_BINGING_NAME, ex.getCurrentTimestamp());
            return bindings;
        }
    }
}

