/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.http;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceInitListener;

public class HttpClientConfig
implements ServiceInitListener<Service> {
    private Integer connectionTimeout = 30000;
    private Integer soTimeout = 30000;
    private String proxyHost;
    private Integer proxyPort;
    private Integer poolingMaxTotal;
    private Integer poolingDefaultMaxPerRoute;
    private Integer poolingTimeToLive;
    private CloseableHttpClient instance;

    public Integer getPoolingTimeToLive() {
        return this.poolingTimeToLive;
    }

    public void setPoolingTimeToLive(Integer poolingTimeToLive) {
        this.poolingTimeToLive = poolingTimeToLive;
    }

    public Integer getPoolingMaxTotal() {
        return this.poolingMaxTotal;
    }

    public void setPoolingMaxTotal(Integer poolingMaxTotal) {
        this.poolingMaxTotal = poolingMaxTotal;
    }

    public Integer getPoolingDefaultMaxPerRoute() {
        return this.poolingDefaultMaxPerRoute;
    }

    public void setPoolingDefaultMaxPerRoute(Integer poolingDefaultMaxPerRoute) {
        this.poolingDefaultMaxPerRoute = poolingDefaultMaxPerRoute;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public HttpClient getInstance() {
        return this.instance;
    }

    @Override
    public void inited(Service service, Config config) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(this.connectionTimeout.intValue()).setSocketTimeout(this.soTimeout.intValue());
        if (this.proxyHost != null) {
            builder.setProxy(new HttpHost(this.proxyHost, this.proxyPort.intValue()));
        }
        HttpClientBuilder hcBuilder = HttpClientBuilder.create().setDefaultRequestConfig(builder.build());
        if (this.poolingMaxTotal != null) {
            hcBuilder.setMaxConnTotal(this.poolingMaxTotal.intValue());
        }
        if (this.poolingDefaultMaxPerRoute != null) {
            hcBuilder.setMaxConnPerRoute(this.poolingDefaultMaxPerRoute.intValue());
        }
        if (this.poolingTimeToLive != null) {
            hcBuilder.setConnectionTimeToLive(this.poolingTimeToLive.longValue(), TimeUnit.MILLISECONDS);
        }
        this.instance = hcBuilder.build();
    }

    @Override
    public void destroyed() {
        try {
            this.instance.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.instance = null;
    }
}

