/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.lob.LobDao;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class LobStoreService
implements Service {
    private static final String DEFAULT_LOB_STORE_CONFIG_NAME = "defaultLobStoreName";
    private HashMap<String, LobStore> stores;
    private String defaultLobStoreName = "default";
    private LobDao lobDao;
    private boolean manageLobSizeOnRdb = true;

    public LobDao getLobDao() {
        return this.lobDao;
    }

    public LobStore getLobStore(String name) {
        LobStore s = this.stores.get(name);
        if (s == null) {
            s = this.getDefaultLobStore();
        }
        return s;
    }

    public LobStore getDefaultLobStore() {
        return this.stores.get(this.defaultLobStoreName);
    }

    public Map<String, LobStore> getLobStoreMap() {
        return new HashMap<String, LobStore>(this.stores);
    }

    public boolean isManageLobSizeOnRdb() {
        return this.manageLobSizeOnRdb;
    }

    @Override
    public void init(Config config) {
        if (config.getValue(DEFAULT_LOB_STORE_CONFIG_NAME) != null) {
            this.defaultLobStoreName = config.getValue(DEFAULT_LOB_STORE_CONFIG_NAME);
        }
        this.stores = new HashMap();
        for (String propName : config.getNames()) {
            Object val = config.getBean(propName);
            if (!(val instanceof LobStore)) continue;
            this.stores.put(propName, (LobStore)val);
        }
        if (config.getValue("manageLobSizeOnRdb") != null) {
            this.manageLobSizeOnRdb = Boolean.valueOf(config.getValue("manageLobSizeOnRdb"));
        }
        this.lobDao = config.getValue("lobDao", LobDao.class);
        if (this.lobDao == null) {
            this.lobDao = new LobDao();
        }
        this.lobDao.init(config.getDependentService(RdbAdapterService.class).getRdbAdapter(), (CounterService)config.getDependentService("OidCounter"), this.manageLobSizeOnRdb);
    }

    @Override
    public void destroy() {
    }
}

