/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.iplass.mtp.impl.lob.LobDao;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStoreRuntimeException;

public class SizeUpdateOutputStream
extends FilterOutputStream {
    private int tenantId;
    private LobData lobData;
    private LobDao dao;
    private boolean closed;

    public SizeUpdateOutputStream(OutputStream out, int tenantId, LobDao dao) {
        super(out);
        this.tenantId = tenantId;
        this.dao = dao;
    }

    private void storeBlobSize() {
        if (!this.dao.updateLobStoreSize(this.tenantId, this.lobData.getLobDataId(), this.lobData.getSize())) {
            throw new LobStoreRuntimeException("Concurrent Update Occured.");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
            this.storeBlobSize();
        }
    }
}

