/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.rdb;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class UpdateSQL
extends UpdateSqlHandler {
    private static final String UPDATE_SQL = "UPDATE OBJ_META SET STATUS='D' ,UP_USER=? ,UP_DATE=systimestamp WHERE TENANT_ID=? AND OBJ_DEF_ID=? AND STATUS='V'";
    private static final String UPDATE_WITH_PATH_SQL = "UPDATE OBJ_META SET STATUS='D' ,OBJ_DEF_PATH=? ,UP_USER=? ,UP_DATE=systimestamp WHERE TENANT_ID=? AND OBJ_DEF_ID=?";

    public String createUpdateSQL(RdbAdapter rdb) {
        return UPDATE_SQL.replaceAll("systimestamp", rdb.systimestamp());
    }

    public void setUpdateParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String metaDataId) throws SQLException {
        String clientId = ExecuteContext.getCurrentContext().getClientId();
        ps.setString(1, clientId);
        ps.setInt(2, tenantId);
        ps.setString(3, metaDataId);
    }

    public String createUpdateWithPathSQL(RdbAdapter rdb) {
        return UPDATE_WITH_PATH_SQL.replaceAll("systimestamp", rdb.systimestamp());
    }

    public void setUpdateWithPathParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String metaDataId, String path) throws SQLException {
        String clientId = rdb.sanitize(ExecuteContext.getCurrentContext().getClientId());
        ps.setString(1, path);
        ps.setString(2, clientId);
        ps.setInt(3, tenantId);
        ps.setString(4, metaDataId);
    }
}

