/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.extend;

import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.selectvalue.SelectValueDefinition;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.extend.WrapperType;
import org.iplass.mtp.impl.properties.extend.select.MetaSelectValue;
import org.iplass.mtp.impl.properties.extend.select.SelectValueService;
import org.iplass.mtp.impl.properties.extend.select.Value;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class SelectType
extends WrapperType {
    private static final long serialVersionUID = 9042652773091106209L;
    private static StringType actualType = new StringType();
    private static SelectValueService svService = ServiceRegistry.getRegistry().getService(SelectValueService.class);
    private List<Value> values;
    private String selectValueMetaDataId;

    public String getSelectValueMetaDataId() {
        return this.selectValueMetaDataId;
    }

    public void setSelectValueMetaDataId(String selectValueMetaDataId) {
        this.selectValueMetaDataId = selectValueMetaDataId;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(List<Value> values) {
        this.values = values;
    }

    public List<Value> runtimeValues() {
        if (this.selectValueMetaDataId != null) {
            MetaSelectValue.SelectValueRuntime r = (MetaSelectValue.SelectValueRuntime)svService.getRuntimeById(this.selectValueMetaDataId);
            if (r == null) {
                return null;
            }
            return r.getMetaData().getValues();
        }
        return this.values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.selectValueMetaDataId == null ? 0 : this.selectValueMetaDataId.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectType other = (SelectType)obj;
        if (this.selectValueMetaDataId == null ? other.selectValueMetaDataId != null : !this.selectValueMetaDataId.equals(other.selectValueMetaDataId)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public SelectType copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public SelectProperty createPropertyDefinitionInstance() {
        SelectProperty def = new SelectProperty();
        if (this.selectValueMetaDataId != null) {
            MetaSelectValue.SelectValueRuntime r = (MetaSelectValue.SelectValueRuntime)svService.getRuntimeById(this.selectValueMetaDataId);
            if (r != null) {
                def.setSelectValueDefinitionName(r.getMetaData().getName());
                SelectValueDefinition svd = Value.toSelectValueDefinition(r.getMetaData().getValues());
                def.setSelectValueList(svd.getSelectValueList());
                def.setLocalizedSelectValueList(svd.getLocalizedSelectValueList());
            }
        } else {
            SelectValueDefinition svd = Value.toSelectValueDefinition(this.values);
            def.setSelectValueList(svd.getSelectValueList());
            def.setLocalizedSelectValueList(svd.getLocalizedSelectValueList());
        }
        return def;
    }

    @Override
    public void applyDefinition(PropertyDefinition def) {
        super.applyDefinition(def);
        SelectProperty spd = (SelectProperty)def;
        if (spd.getSelectValueDefinitionName() != null) {
            MetaSelectValue.SelectValueRuntime r = (MetaSelectValue.SelectValueRuntime)svService.getRuntimeByName(spd.getSelectValueDefinitionName());
            if (r == null) {
                throw new EntityRuntimeException("SelectValue definition:" + spd.getSelectValueDefinitionName() + " is undefined.");
            }
            this.selectValueMetaDataId = r.getMetaData().getId();
            this.values = null;
        } else {
            this.selectValueMetaDataId = null;
            SelectValueDefinition svd = new SelectValueDefinition();
            svd.setSelectValueList(spd.getSelectValueList());
            svd.setLocalizedSelectValueList(spd.getLocalizedSelectValueList());
            this.values = Value.toValues(svd);
        }
    }

    @Override
    public Object createRuntime(MetaProperty metaProperty, MetaEntity metaEntity) {
        return null;
    }

    @Override
    public Class<?> storeType() {
        return SelectValue.class;
    }

    @Override
    public PropertyType actualType() {
        return actualType;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.SELECT;
    }

    @Override
    public PropertyDefinitionType getDataStoreEnumType() {
        return PropertyDefinitionType.STRING;
    }

    @Override
    public Object fromDataStore(Object fromDataStore) {
        if (fromDataStore == null) {
            return null;
        }
        String value = (String)fromDataStore;
        List<Value> runtimeValues = this.runtimeValues();
        if (runtimeValues != null) {
            for (Value v : runtimeValues) {
                if (!v.getValue().equals(value)) continue;
                String dispName = I18nUtil.stringMeta(v.getDisplayName(), v.getLocalizedDisplayNameList());
                SelectValue select = new SelectValue(v.getValue(), dispName);
                return select;
            }
        }
        return null;
    }

    @Override
    public Object toDataStore(Object toDataStore) {
        if (toDataStore == null) {
            return null;
        }
        String value = null;
        value = toDataStore instanceof String ? (String)toDataStore : ((SelectValue)toDataStore).getValue();
        List<Value> runtimeValues = this.runtimeValues();
        if (runtimeValues != null) {
            for (Value v : runtimeValues) {
                if (!v.getValue().equals(value)) continue;
                return value;
            }
        }
        throw new EntityRuntimeException("SelectValue:" + value + " not defined.");
    }

    @Override
    public boolean isCompatibleTo(PropertyType another) {
        if (another instanceof SelectType) {
            return true;
        }
        return super.isCompatibleTo(another);
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return ((SelectValue)value).getValue();
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        List<Value> runtimeValues = this.runtimeValues();
        if (runtimeValues != null) {
            for (Value v : runtimeValues) {
                if (!v.getValue().equals(strValue)) continue;
                String dispName = I18nUtil.stringMeta(v.getDisplayName(), v.getLocalizedDisplayNameList());
                SelectValue select = new SelectValue(v.getValue(), dispName);
                return select;
            }
        }
        return null;
    }
}

