/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class AsOfSyntax
implements Syntax<AsOf>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public AsOf parse(ParseContext str) throws ParseException {
        AsOf.AsOfSpec asOfSpec = null;
        ValueExpression asOf = null;
        if (!str.equalsNextToken("AS", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("AS expected.", this, str));
        }
        str.consumeChars("AS".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("OF", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("OF expected.", this, str));
        }
        str.consumeChars("OF".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.equalsNextToken("NOW", ParseContext.TOKEN_DELIMITERS)) {
            str.consumeChars("NOW".length());
            asOfSpec = AsOf.AsOfSpec.NOW;
        } else if (str.equalsNextToken("UPDATE", ParseContext.TOKEN_DELIMITERS)) {
            str.consumeChars("UPDATE".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
            if (!str.equalsNextToken("TIME", ParseContext.TOKEN_DELIMITERS)) {
                throw new ParseException(new EvalError("time expected.", this, str));
            }
            str.consumeChars("TIME".length());
            asOfSpec = AsOf.AsOfSpec.UPDATE_TIME;
        } else {
            asOf = this.polynomial.parse(str);
            asOfSpec = AsOf.AsOfSpec.SPEC_VALUE;
        }
        AsOf ao = new AsOf(asOfSpec);
        if (asOf != null) {
            ao.setValue(asOf);
        }
        return ao;
    }
}

