/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.aggregate;

import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.aggregate.Avg;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.entity.query.value.aggregate.Max;
import org.iplass.mtp.entity.query.value.aggregate.Median;
import org.iplass.mtp.entity.query.value.aggregate.Min;
import org.iplass.mtp.entity.query.value.aggregate.Mode;
import org.iplass.mtp.entity.query.value.aggregate.StdDevPop;
import org.iplass.mtp.entity.query.value.aggregate.StdDevSamp;
import org.iplass.mtp.entity.query.value.aggregate.Sum;
import org.iplass.mtp.entity.query.value.aggregate.VarPop;
import org.iplass.mtp.entity.query.value.aggregate.VarSamp;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class AggregateSyntax
implements Syntax<Aggregate>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public Aggregate parse(ParseContext str) throws ParseException {
        ValueExpression nestedValue;
        Aggregate ag = null;
        int currentIndex = str.getCurrentIndex();
        boolean isCount = false;
        String token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if (token == null) {
            throw new ParseException(new EvalError("aggregate function expected.", this, str));
        }
        switch (token = token.toUpperCase()) {
            case "COUNT": {
                ag = new Count();
                isCount = true;
                break;
            }
            case "SUM": {
                ag = new Sum();
                break;
            }
            case "MAX": {
                ag = new Max();
                break;
            }
            case "MIN": {
                ag = new Min();
                break;
            }
            case "AVG": {
                ag = new Avg();
                break;
            }
            case "STDDEV_POP": {
                ag = new StdDevPop();
                break;
            }
            case "STDDEV_SAMP": {
                ag = new StdDevSamp();
                break;
            }
            case "VAR_POP": {
                ag = new VarPop();
                break;
            }
            case "VAR_SAMP": {
                ag = new VarSamp();
                break;
            }
            case "MODE": {
                ag = new Mode();
                break;
            }
            case "MEDIAN": {
                ag = new Median();
                break;
            }
            default: {
                str.setCurrentIndex(currentIndex);
                throw new ParseException(new EvalError("aggregate function expected.", this, str));
            }
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars("(".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!isCount) {
            nestedValue = this.polynomial.parse(str);
            ag.setValue(nestedValue);
        } else if (!str.startsWith(")")) {
            if (str.equalsNextToken("DISTINCT", ParseContext.WHITE_SPACES)) {
                ((Count)ag).setDistinct(true);
                str.consumeChars("DISTINCT".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            nestedValue = this.polynomial.parse(str);
            ag.setValue(nestedValue);
        }
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        return ag;
    }
}

