/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.postgresql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.rdb.adapter.HintPlace;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;
import org.iplass.mtp.impl.rdb.adapter.MultiTableUpdateMethod;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UnsupportedDataTypeException;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.InOperatorBulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.function.DynamicTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.StaticTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.ExtractDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.LocalTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.rdb.postgresql.PostgreSQLMultiInsertContext;
import org.iplass.mtp.impl.rdb.postgresql.function.PostgreSQLDateAddFunctionAdapter;
import org.iplass.mtp.impl.rdb.postgresql.function.PostgreSQLDateDiffFunctionAdapter;
import org.iplass.mtp.impl.rdb.postgresql.function.PostgreSQLRoundTruncFunctionAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class PostgreSQLRdbAdapter
extends RdbAdapter {
    private static final String[] optimizerHintBracket = new String[]{"/*+", "*/"};
    private static final String DATE_MIN = "-47120101000000000";
    private static final String DATE_MAX = "99991231235959999";
    long dateMin;
    long dateMax;
    private boolean supportOptimizerHint = false;
    private String timestampFunction = "CURRENT_TIMESTAMP(3)";
    private boolean escapeBackslash = false;
    private boolean enableBindHint;
    private int maxFetchSize = 100;
    private int defaultQueryTimeout;
    private int lockTimeout = 0;

    public PostgreSQLRdbAdapter() {
        this.addFunction(new StaticTypedFunctionAdapter("CHAR_LENGTH", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("INSTR", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("CONCAT", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("SUBSTR", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("REPLACE", String.class));
        this.addFunction(new DynamicTypedFunctionAdapter("MOD", new int[]{0, 1}));
        this.addFunction(new StaticTypedFunctionAdapter("SQRT", Double.class));
        this.addFunction(new DynamicTypedFunctionAdapter("POWER", new int[]{0, 1}));
        this.addFunction(new DynamicTypedFunctionAdapter("ABS", new int[]{0}));
        this.addFunction(new StaticTypedFunctionAdapter("CEIL", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("FLOOR", Long.class));
        this.addFunction(new PostgreSQLRoundTruncFunctionAdapter("ROUND", "ROUND"));
        this.addFunction(new PostgreSQLRoundTruncFunctionAdapter("TRUNCATE", "TRUNC"));
        this.addFunction(new StaticTypedFunctionAdapter("UPPER", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("LOWER", String.class));
        this.addFunction(new ExtractDateFunctionAdapter("SECOND"));
        this.addFunction(new ExtractDateFunctionAdapter("MINUTE"));
        this.addFunction(new ExtractDateFunctionAdapter("HOUR"));
        this.addFunction(new ExtractDateFunctionAdapter("DAY"));
        this.addFunction(new ExtractDateFunctionAdapter("MONTH"));
        this.addFunction(new ExtractDateFunctionAdapter("YEAR"));
        this.addFunction(new PostgreSQLDateAddFunctionAdapter());
        this.addFunction(new PostgreSQLDateDiffFunctionAdapter());
        this.addFunction(new CurrentDateFunctionAdapter());
        this.addFunction(new CurrentTimeFunctionAdapter());
        this.addFunction(new CurrentDateTimeFunctionAdapter());
        this.addFunction(new LocalTimeFunctionAdapter());
        DateFormatSymbols symbols = new DateFormatSymbols();
        symbols.setEras(new String[]{"-", ""});
        I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
        SimpleDateFormat sdfMin = new SimpleDateFormat("GyyyyMMddHHmmssSSS", symbols);
        sdfMin.setTimeZone(i18n.getTimezone());
        SimpleDateFormat sdfMax = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        sdfMax.setTimeZone(i18n.getTimezone());
        try {
            this.dateMin = sdfMin.parse(DATE_MIN).getTime();
            this.dateMax = sdfMax.parse(DATE_MAX).getTime();
        }
        catch (ParseException e) {
            throw new UnsupportedDataTypeException(e);
        }
    }

    @Override
    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(int defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    @Override
    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public boolean isEscapeBackslash() {
        return this.escapeBackslash;
    }

    public void setEscapeBackslash(boolean escapeBackslash) {
        this.escapeBackslash = escapeBackslash;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public Connection getConnection(String connectionFactoryName) throws SQLException {
        ConnectionFactory cf = connectionFactoryName == null ? ServiceRegistry.getRegistry().getService(ConnectionFactory.class) : (ConnectionFactory)ServiceRegistry.getRegistry().getService(connectionFactoryName);
        return cf.getConnection();
    }

    @Override
    public String getOptimizerHint() {
        return null;
    }

    @Override
    public HintPlace getOptimizerHintPlace() {
        return HintPlace.HEAD_OF_SQL;
    }

    @Override
    public String[] getOptimizerHintBracket() {
        return optimizerHintBracket;
    }

    public String getTimestampFunction() {
        return this.timestampFunction;
    }

    public void setTimestampFunction(String timestampFunction) {
        this.timestampFunction = timestampFunction;
    }

    private void checkDateRange(java.util.Date date) {
        long time;
        if (date != null && (this.dateMin > (time = date.getTime()) || this.dateMax < time)) {
            throw new UnsupportedDataTypeException("out of range Date:" + date);
        }
    }

    @Override
    public String toDateExpression(Date date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return "CAST('" + fmt.format(date) + "' AS DATE )";
    }

    @Override
    public String toTimeExpression(Time time) {
        this.checkDateRange(time);
        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
        return "CAST('1970-01-01 " + fmt.format(time) + "' AS TIMESTAMP(0))";
    }

    @Override
    public String toTimeStampExpression(Timestamp date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return "CAST('" + fmt.format(date) + "' AS TIMESTAMP(3))";
    }

    @Override
    public String systimestamp() {
        return this.timestampFunction;
    }

    @Override
    public MultiInsertContext createMultiInsertContext(Statement stmt) {
        return new PostgreSQLMultiInsertContext(stmt);
    }

    @Override
    public String[] castExp(int sqlType, Integer lengthOrPrecision, Integer scale) {
        if (sqlType == 3 && scale != null && scale < 0) {
            if (lengthOrPrecision == null) {
                return new String[]{"ROUND(CAST(", " AS NUMERIC(65,0))," + scale + ")"};
            }
            return new String[]{"ROUND(CAST(", " AS NUMERIC(" + lengthOrPrecision + -scale.intValue() + ",0))," + scale + ")"};
        }
        return super.castExp(sqlType, lengthOrPrecision, scale);
    }

    @Override
    protected String getDataTypeOf(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                if (lengthOrPrecision == null) {
                    return "VARCHAR(4000)";
                }
                return "VARCHAR(" + lengthOrPrecision + ")";
            }
            case -5: {
                return "BIGINT";
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return "NUMERIC(65,30)";
                    }
                    return "NUMERIC(35" + scale + "," + scale + ")";
                }
                if (scale == null) {
                    return "NUMERIC(" + lengthOrPrecision + ",0)";
                }
                return "NUMERIC(" + lengthOrPrecision + "," + scale + ")";
            }
            case 91: {
                return "DATE";
            }
            case 8: {
                return "NUMERIC(65,30)";
            }
            case 92: 
            case 93: {
                return "TIMESTAMP";
            }
        }
        return null;
    }

    @Override
    public String dual() {
        return "";
    }

    @Override
    public String rowLockExpression() {
        if (this.lockTimeout == 0) {
            return "FOR UPDATE NOWAIT";
        }
        return "FOR UPDATE";
    }

    @Override
    public String toLimitSql(String selectSql, int limitCount, int offset, boolean asBind) {
        if (asBind) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectSql);
            sb.append(" LIMIT ? OFFSET ?");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(selectSql);
        sb.append(" LIMIT " + limitCount + " OFFSET " + offset);
        return sb.toString();
    }

    @Override
    public Object[] toLimitSqlBindValue(int limitCount, int offset) {
        return new Integer[]{limitCount, offset};
    }

    @Override
    public boolean isDuplicateValueException(SQLException e) {
        return "23505".equals(e.getSQLState());
    }

    @Override
    public boolean isDeadLock(SQLException e) {
        return "40P01".equals(e.getSQLState());
    }

    @Override
    public boolean isLockFailed(SQLException e) {
        return "55P03".equals(e.getSQLState());
    }

    @Override
    public boolean isCastFailed(SQLException e) {
        return "22007".equals(e.getSQLState()) || "22P02".equals(e.getSQLState());
    }

    @Override
    public String addDate(String dateExpression, int day) {
        String ret = dateExpression + "+ ' " + day + " DAYS'";
        return ret;
    }

    @Override
    public String checkStatusQuery() {
        return "SELECT 1";
    }

    @Override
    public String likePattern(String str) {
        return str;
    }

    @Override
    public String escape() {
        if (this.escapeBackslash) {
            return "ESCAPE '\\\\'";
        }
        return "ESCAPE '\\'";
    }

    @Override
    public String tableAlias(String selectSql) {
        return selectSql;
    }

    @Override
    public boolean isSupportGroupingExtention(GroupBy.RollType rollType) {
        return false;
    }

    @Override
    public String rollUpStart(GroupBy.RollType rollType) {
        return "";
    }

    @Override
    public String rollUpEnd(GroupBy.RollType rollType) {
        return "";
    }

    @Override
    public String seqNextSelectSql(String sequenceName, int tenantId, String entityDefId) {
        return "SELECT NEXTVAL('" + sequenceName + "')";
    }

    @Override
    public String sanitize(String str) {
        if (str == null) {
            return null;
        }
        boolean needSanitaizing = false;
        char current = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\'': {
                    needSanitaizing = true;
                    break;
                }
                case '\\': {
                    if (!this.escapeBackslash) break;
                    needSanitaizing = true;
                    break;
                }
            }
            if (needSanitaizing) break;
        }
        if (!needSanitaizing) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\'': {
                    buff.append('\'');
                    break;
                }
                case '\\': {
                    if (!this.escapeBackslash) break;
                    buff.append('\\');
                    break;
                }
            }
            buff.append(current);
        }
        return buff.toString();
    }

    @Override
    public String initBlob() {
        return "null";
    }

    @Override
    public boolean isUseSubQueryForIndexJoin() {
        return false;
    }

    @Override
    public CharSequence cast(int fromSqlType, int toSqlType, CharSequence valExpr, Integer lengthOrPrecision, Integer scale) {
        if (toSqlType == 3 && scale != null && scale < 0) {
            CharSequence castString = super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, 0);
            return "ROUND(" + castString + "," + scale + ")";
        }
        return super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, scale);
    }

    @Override
    public void appendSortSpecExpression(StringBuilder sb, CharSequence sortValue, SortSpec.SortType sortType, SortSpec.NullOrderingSpec nullOrderingSpec) {
        sb.append(sortValue);
        if (sortType != null) {
            switch (sortType) {
                case ASC: {
                    sb.append(" ASC");
                    break;
                }
                case DESC: {
                    sb.append(" DESC");
                    break;
                }
            }
        }
        if (nullOrderingSpec != null) {
            switch (nullOrderingSpec) {
                case FIRST: {
                    sb.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    sb.append(" NULLS LAST");
                    break;
                }
            }
        }
    }

    @Override
    public String[] convertTZ(String to) {
        String[] ret = new String[]{"TIMEZONE('" + to + "',CAST(", " AS TIMESTAMPTZ(3)))"};
        return ret;
    }

    @Override
    public boolean isEnableInPartitioning() {
        return false;
    }

    @Override
    public int getInPartitioningSize() {
        return -1;
    }

    @Override
    public String deleteTemporaryTable(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    public boolean isSupportGlobalTemporaryTable() {
        return false;
    }

    @Override
    public boolean isSupportAutoClearTemporaryTableWhenCommit() {
        return true;
    }

    @Override
    public String createLocalTemporaryTable(String tableName, String baseTableName, String[] baseColumnName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TEMPORARY TABLE ");
        sb.append(tableName);
        sb.append(" ON COMMIT DROP AS SELECT ");
        for (int i = 0; i < baseColumnName.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(baseColumnName[i]);
        }
        sb.append(" FROM ");
        sb.append(baseTableName);
        sb.append(" WITH NO DATA");
        return sb.toString();
    }

    @Override
    public boolean isSupportGroupingExtentionWithOrderBy() {
        return false;
    }

    @Override
    public boolean isSupportGroupingExtention() {
        return false;
    }

    @Override
    public boolean isEnableBindHint() {
        return this.enableBindHint;
    }

    public void setEnableBindHint(boolean enableBindHint) {
        this.enableBindHint = enableBindHint;
    }

    @Override
    public boolean isAlwaysBind() {
        return false;
    }

    @Override
    public int getBatchSize() {
        return 0;
    }

    @Override
    public int getThresholdCountOfUsePrepareStatement() {
        return -1;
    }

    @Override
    public BulkInsertContext createBulkInsertContext() {
        return new PreparedBulkInsertContext();
    }

    @Override
    public BulkUpdateContext createBulkUpdateContext() {
        return new PreparedBulkUpdateContext();
    }

    @Override
    public BulkDeleteContext createBulkDeleteContext() {
        return new InOperatorBulkDeleteContext();
    }

    @Override
    public MultiTableUpdateMethod getMultiTableUpdateMethod() {
        return MultiTableUpdateMethod.NO_SUPPORT;
    }

    @Override
    public ResultSet getTableNames(String tableNamePattern, Connection con) throws SQLException {
        DatabaseMetaData dbMeta = con.getMetaData();
        return dbMeta.getTables(null, con.getSchema(), tableNamePattern, null);
    }

    @Override
    public boolean isSupportWindowFunction() {
        return true;
    }

    @Override
    public boolean isSupportOptimizerHint() {
        return this.supportOptimizerHint;
    }

    public void setSupportOptimizerHint(boolean supportOptimizerHint) {
        this.supportOptimizerHint = supportOptimizerHint;
    }

    @Override
    public boolean isSupportTableHint() {
        return false;
    }

    @Override
    public String[] getTableHintBracket() {
        return null;
    }

    @Override
    public boolean isSupportBlobType() {
        return false;
    }
}

