/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantI18nInfo;

public class MetaTenantI18nInfo
extends MetaTenantConfig<TenantI18nInfo> {
    private static final long serialVersionUID = -7077921989197723776L;
    private boolean useMultilingual = false;
    private List<String> useLanguageList = new ArrayList<String>();
    private String locale;
    private String timezone;
    private String outputDateFormat;
    private String browserInputDateFormat;

    public boolean isUseMultilingual() {
        return this.useMultilingual;
    }

    public void setUseMultilingual(boolean useMultilingual) {
        this.useMultilingual = useMultilingual;
    }

    public List<String> getUseLanguageList() {
        return this.useLanguageList;
    }

    public void setUseLanguageList(List<String> useLanguageList) {
        this.useLanguageList = useLanguageList;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getOutputDateFormat() {
        return this.outputDateFormat;
    }

    public void setOutputDateFormat(String outputDateFormat) {
        this.outputDateFormat = outputDateFormat;
    }

    public String getBrowserInputDateFormat() {
        return this.browserInputDateFormat;
    }

    public void setBrowserInputDateFormat(String browserInputDateFormat) {
        this.browserInputDateFormat = browserInputDateFormat;
    }

    @Override
    public MetaData copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(TenantI18nInfo definition) {
        this.setUseMultilingual(definition.isUseMultilingual());
        this.setUseLanguageList(definition.getUseLanguageList());
        this.setLocale(definition.getLocale());
        this.setTimezone(definition.getTimezone());
        this.setOutputDateFormat(definition.getOutputDateFormat());
        this.setBrowserInputDateFormat(definition.getBrowserInputDateFormat());
    }

    @Override
    public TenantI18nInfo currentConfig() {
        TenantI18nInfo definition = new TenantI18nInfo();
        definition.setLocale(this.locale);
        definition.setTimezone(this.timezone);
        definition.setOutputDateFormat(this.outputDateFormat);
        definition.setBrowserInputDateFormat(this.browserInputDateFormat);
        definition.setUseMultilingual(this.useMultilingual);
        definition.setUseLanguageList(this.useLanguageList);
        return definition;
    }

    @Override
    public MetaTenantI18nInfoRuntime createRuntime(MetaTenant.MetaTenantHandler tenantRuntime) {
        return new MetaTenantI18nInfoRuntime();
    }

    public class MetaTenantI18nInfoRuntime
    extends MetaTenantConfig.MetaTenantConfigRuntime {
        private Locale localeRuntime;
        private TimeZone timeZoneRuntime;
        private Locale langLocaleRuntime;

        public MetaTenantI18nInfoRuntime() {
            try {
                I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
                this.localeRuntime = MetaTenantI18nInfo.this.locale != null ? I18nUtil.getLocale(MetaTenantI18nInfo.this.locale) : i18n.getLocale();
                this.langLocaleRuntime = i18n.selectLangLocale(this.localeRuntime);
                this.timeZoneRuntime = MetaTenantI18nInfo.this.timezone != null ? TimeZone.getTimeZone(MetaTenantI18nInfo.this.timezone) : i18n.getTimezone();
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        @Override
        public MetaData getMetaData() {
            return MetaTenantI18nInfo.this;
        }

        @Override
        public void applyMetaDataToTenant(Tenant tenant) {
        }

        public Locale getLocale() {
            return this.localeRuntime;
        }

        public Locale getLangLocale() {
            return this.langLocaleRuntime;
        }

        public TimeZone getTimeZone() {
            return this.timeZoneRuntime;
        }
    }
}

