/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;
import org.iplass.mtp.tenant.Tenant;

public class TenantControlSQL
extends UpdateSqlHandler {
    public static final String COLUMNS = "NAME, DESCRIPTION, URL, YUKO_DATE_FROM, YUKO_DATE_TO, CRE_USER, CRE_DATE, UP_USER, UP_DATE";

    public String createRegistSQL(RdbAdapter rdb) {
        return "INSERT INTO T_TENANT (NAME, DESCRIPTION, URL, YUKO_DATE_FROM, YUKO_DATE_TO, CRE_USER, CRE_DATE, UP_USER, UP_DATE) VALUES (?, ?, ?, ?, ?, ?, " + rdb.systimestamp() + ", ?, " + rdb.systimestamp() + ")";
    }

    public void setRegistParameter(RdbAdapter rdb, PreparedStatement ps, Tenant tenant, String createUser) throws SQLException {
        this.setParameter(ps, tenant, createUser, true);
    }

    private int setParameter(PreparedStatement ps, Tenant tenant, String user, boolean isRegist) throws SQLException {
        int num = 1;
        ps.setString(num++, tenant.getName());
        ps.setString(num++, tenant.getDescription());
        if (isRegist) {
            ps.setString(num++, tenant.getUrl());
        }
        ps.setDate(num++, tenant.getFrom());
        ps.setDate(num++, tenant.getTo());
        if (isRegist) {
            ps.setString(num++, user);
        }
        ps.setString(num++, user);
        return num;
    }

    public String createUpdateSQL(RdbAdapter rdb, boolean forceUpdate) {
        String sql = "UPDATE T_TENANT SET NAME = ?, DESCRIPTION = ?, YUKO_DATE_FROM = ?, YUKO_DATE_TO = ?, UP_USER = ?, UP_DATE = " + rdb.systimestamp() + " WHERE ID = ?";
        if (!forceUpdate) {
            sql = sql + " AND UP_DATE = ?";
        }
        return sql;
    }

    public void setUpdateParameter(RdbAdapter rdb, PreparedStatement ps, Tenant tenant, String updateUser, boolean forceUpdate) throws SQLException {
        int num = this.setParameter(ps, tenant, updateUser, false);
        ps.setInt(num++, tenant.getId());
        if (!forceUpdate) {
            ps.setTimestamp(num++, tenant.getUpdateDate());
        }
    }
}

