/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.transaction;

import org.iplass.mtp.impl.transaction.LocalTransaction;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransactionManager
implements TransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalTransactionManager.class);
    static ThreadLocal<LocalTransaction> transaction = new ThreadLocal();

    @Override
    public Transaction newTransaction() {
        return this.newTransaction(false);
    }

    @Override
    public Transaction currentTransaction() {
        Transaction t = transaction.get();
        if (t == null) {
            return Transaction.NO_TRANSACTION;
        }
        return t;
    }

    public void checkAndClean() {
        LocalTransaction t = transaction.get();
        while (t != null) {
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                logger.warn("transaction resource leak... check Logic!!:" + t);
                if (t.isRollbackOnly()) {
                    logger.warn("rollback leaked transaction:" + t);
                    t.rollback();
                } else {
                    logger.warn("commit leaked transaction:" + t);
                    t.commit();
                }
            } else if (t instanceof LocalTransaction) {
                t.close();
            }
            t = transaction.get();
        }
    }

    @Override
    public Transaction newTransaction(boolean readOnly) {
        return this.createTran(readOnly, false);
    }

    protected Transaction createTran(boolean readOnly, boolean noTransaction) {
        LocalTransaction current = transaction.get();
        LocalTransaction newT = new LocalTransaction(readOnly, current, noTransaction);
        transaction.set(newT);
        return newT;
    }

    @Override
    public Transaction suspend() {
        return this.createTran(false, true);
    }

    @Override
    public void resume(Transaction t) {
        ((LocalTransaction)t).close();
    }
}

