/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtil {
    private HashUtil() {
    }

    public static String digest(String target, String algorithm) throws NoSuchAlgorithmException {
        return HashUtil.digest(target.getBytes(), algorithm);
    }

    public static String digest(String target, String algorithm, String charsetName) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return HashUtil.digest(target.getBytes(charsetName), algorithm);
    }

    public static String digest(byte[] target, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] buf = md.digest(target);
        StringBuilder sb = new StringBuilder();
        return HashUtil.hexToString(sb, buf);
    }

    public static String hexToString(StringBuilder sb, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            HashUtil.hexDigit(sb, data[i]);
        }
        String buf = sb.toString();
        sb.delete(0, sb.length());
        return buf.toString();
    }

    public static void hexDigit(StringBuilder sb, byte byte0) {
        char c = (char)(byte0 >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        sb.append(c);
        c = (char)(byte0 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        sb.append(c);
    }
}

