/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.message.MessageService;
import org.iplass.mtp.impl.util.UTF8ResourceBundleControl;
import org.iplass.mtp.spi.ServiceRegistry;

public class ResourceBundleWrapper {
    private static final String RESOURCE_FILE_NAME = "Application";
    private static MessageService ms = ServiceRegistry.getRegistry().getService(MessageService.class);
    private static UTF8ResourceBundleControl utf8ctrl = new UTF8ResourceBundleControl();

    public static String getString(String key) {
        return ResourceBundleWrapper.getString(key, (Object[])null);
    }

    public static String getString(String key, Object ... arguments) {
        return ResourceBundleWrapper.getString(ExecuteContext.getCurrentContext().getLangLocale(), key, arguments);
    }

    public static String getString(Locale langLocale, String key, Object ... arguments) {
        try {
            ResourceBundle resource = ResourceBundleWrapper.getResourceBundle(RESOURCE_FILE_NAME, langLocale);
            String resourceString = resource.getString(key);
            if (resourceString != null && arguments != null && arguments.length > 0) {
                return MessageFormat.format(resourceString, arguments);
            }
            return resourceString;
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    public static String getString(ResourceBundle resource, String key, Object ... arguments) {
        String resourceString = resource.getString(key);
        if (resourceString != null && arguments != null && arguments.length > 0) {
            return MessageFormat.format(resourceString, arguments);
        }
        return resourceString;
    }

    public static ResourceBundle getResourceBundle(String baseName) {
        return ResourceBundleWrapper.getResourceBundle(baseName, ExecuteContext.getCurrentContext().getLangLocale());
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale langLocale) {
        ResourceBundle.Control ctrl = ms.getResourceBundleControl(baseName);
        if (ctrl == null) {
            return ResourceBundle.getBundle(baseName, langLocale, utf8ctrl);
        }
        return ResourceBundle.getBundle(baseName, langLocale, ctrl);
    }

    public static String localString(String baseName, String key, Object ... args) {
        ResourceBundle localStrings = ResourceBundleWrapper.getResourceBundle(baseName);
        if (localStrings == null) {
            return null;
        }
        return ResourceBundleWrapper.getString(localStrings, key, args);
    }
}

