/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMagicByte(File tempFile, String type, String fileName) {
        String ext;
        byte[] buf = new byte[128];
        FileInputStream is = null;
        try {
            is = new FileInputStream(tempFile);
            ((InputStream)is).read(buf);
        }
        catch (IOException e) {
            logger.warn("upload file is externally deleted. maybe contains virus.", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.warn("can not close resource:" + tempFile.getName(), (Throwable)e);
                }
            }
        }
        StringBuffer temp = new StringBuffer();
        int cnt = 0;
        for (byte b : buf) {
            temp.append(String.format("%02x", b));
            if (++cnt > 64) break;
        }
        String magicByte = temp.toString();
        if (type.equals("image/gif") && !magicByte.startsWith("474946383761") && !magicByte.startsWith("474946383961")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.equals("image/bmp") && !magicByte.startsWith("424d")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.equals("image/jpeg") && !magicByte.startsWith("ffd8")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.equals("image/png") && !magicByte.startsWith("89504e470d0a1a0a")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.equals("application/x-shockwave-flash") && !magicByte.startsWith("465753") && !magicByte.startsWith("435753")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.equals("application/pdf") && !magicByte.startsWith("25504446")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.startsWith("application/vnd.ms-") || type.startsWith("application/msword")) {
            String ext2;
            if (magicByte.startsWith("504b030414000600")) {
                return;
            }
            if (!(magicByte.startsWith("d0cf11e0a1b11ae1") || magicByte.startsWith("7b5c72746631") || StringUtil.equalsIgnoreCase(ext2 = StringUtil.substringAfterLast(fileName, "."), "csv"))) {
                throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
            }
        }
        if (!StringUtil.isEmpty(fileName) && StringUtil.equalsIgnoreCase(ext = StringUtil.substringAfterLast(fileName, "."), "xls") && !magicByte.startsWith("d0cf11e0a1b11ae1")) {
            throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
        }
        if (type.startsWith("application/vnd.openxmlformats-officedocument") && !magicByte.startsWith("504b030414000600") && !magicByte.startsWith("d0cf11e0a1b11ae1")) {
            ext = StringUtil.substringAfterLast(fileName, ".");
            if (!magicByte.startsWith("504b030414000808") && !magicByte.startsWith("d0cf11e0a1b11ae1") || !StringUtil.equalsIgnoreCase(ext, "xlsx") && !StringUtil.equalsIgnoreCase(ext, "docx") && !StringUtil.equalsIgnoreCase(ext, "pptx")) {
                throw new ApplicationException(UploadFileUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.invalidFileMsg", null));
            }
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

