/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.ScriptingValidation;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationContext;
import org.iplass.mtp.impl.validation.ValidationHandler;

public class MetaValidationScripting
extends MetaValidation {
    private static final long serialVersionUID = 8226573142915272860L;
    public static final String ENTITY_BINDING_NAME = "entity";
    public static final String PROPERTY_NAME_BINDING_NAME = "propertyName";
    public static final String VALUE_BINDING_NAME = "value";
    private String script;
    private boolean asArray = false;

    public boolean isAsArray() {
        return this.asArray;
    }

    public void setAsArray(boolean asArray) {
        this.asArray = asArray;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        ScriptingValidation def = (ScriptingValidation)definition;
        this.script = def.getScript();
        this.asArray = def.isAsArray();
    }

    @Override
    public MetaValidationScripting copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        return new ValidationHandlerScripting(entity, property);
    }

    @Override
    public ScriptingValidation currentConfig(EntityContext context) {
        ScriptingValidation def = new ScriptingValidation();
        this.fillTo(def);
        def.setScript(this.script);
        def.setAsArray(this.asArray);
        return def;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.asArray ? 1231 : 1237);
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationScripting other = (MetaValidationScripting)obj;
        if (this.asArray != other.asArray) {
            return false;
        }
        return !(this.script == null ? other.script != null : !this.script.equals(other.script));
    }

    private class ValidationHandlerScripting
    extends ValidationHandler {
        private static final String SCRIPT_PREFIX = "ValidationHandlerScripting_script";
        private Script compiledScript;
        private ScriptEngine scriptEngine;

        ValidationHandlerScripting(MetaEntity entity, MetaProperty property) {
            super(MetaValidationScripting.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            String scriptName = null;
            for (int i = 0; i < property.getValidations().size(); ++i) {
                if (MetaValidationScripting.this != property.getValidations().get(i)) continue;
                scriptName = "ValidationHandlerScripting_script_" + entity.getId() + "_" + property.getId() + "_" + i;
                break;
            }
            this.compiledScript = this.scriptEngine.createScript(MetaValidationScripting.this.script, scriptName);
        }

        @Override
        public boolean validate(Object value, ValidationContext context) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute(MetaValidationScripting.ENTITY_BINDING_NAME, context.getValidatingDataModel());
            sc.setAttribute(MetaValidationScripting.PROPERTY_NAME_BINDING_NAME, context.getValidatePropertyName());
            sc.setAttribute(MetaValidationScripting.VALUE_BINDING_NAME, value);
            Boolean retVal = (Boolean)this.compiledScript.eval(sc);
            if (retVal == null) {
                return false;
            }
            return retVal;
        }

        @Override
        public boolean validateArray(Object[] values, ValidationContext context) {
            if (MetaValidationScripting.this.asArray) {
                return this.validate(values, context);
            }
            return super.validateArray(values, context);
        }
    }
}

