/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import javax.validation.Validator;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.BinarySizeValidation;
import org.iplass.mtp.entity.definition.validations.BinaryTypeValidation;
import org.iplass.mtp.entity.definition.validations.LengthValidation;
import org.iplass.mtp.entity.definition.validations.NotNullValidation;
import org.iplass.mtp.entity.definition.validations.RangeValidation;
import org.iplass.mtp.entity.definition.validations.RegexValidation;
import org.iplass.mtp.entity.definition.validations.ScriptingValidation;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.MetaValidationBinarySize;
import org.iplass.mtp.impl.validation.MetaValidationBinaryType;
import org.iplass.mtp.impl.validation.MetaValidationLength;
import org.iplass.mtp.impl.validation.MetaValidationNotNull;
import org.iplass.mtp.impl.validation.MetaValidationRange;
import org.iplass.mtp.impl.validation.MetaValidationRegex;
import org.iplass.mtp.impl.validation.MetaValidationScripting;
import org.iplass.mtp.impl.validation.bean.BeanValidationConfig;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class ValidationService
implements Service {
    private BeanValidationConfig beanValidation;
    private Validator validator;

    public Validator getValidator() {
        return this.validator;
    }

    public BeanValidationConfig getBeanValidation() {
        return this.beanValidation;
    }

    public MetaValidation createValidationMetaData(ValidationDefinition def) {
        if (def instanceof NotNullValidation) {
            MetaValidationNotNull instance = new MetaValidationNotNull();
            instance.applyConfig((NotNullValidation)def);
            return instance;
        }
        if (def instanceof RangeValidation) {
            MetaValidationRange instance = new MetaValidationRange();
            instance.applyConfig((RangeValidation)def);
            return instance;
        }
        if (def instanceof RegexValidation) {
            MetaValidationRegex instance = new MetaValidationRegex();
            instance.applyConfig(def);
            return instance;
        }
        if (def instanceof LengthValidation) {
            MetaValidationLength instance = new MetaValidationLength();
            instance.applyConfig(def);
            return instance;
        }
        if (def instanceof ScriptingValidation) {
            MetaValidationScripting instance = new MetaValidationScripting();
            instance.applyConfig(def);
            return instance;
        }
        if (def instanceof BinarySizeValidation) {
            MetaValidationBinarySize instance = new MetaValidationBinarySize();
            instance.applyConfig((BinarySizeValidation)def);
            return instance;
        }
        if (def instanceof BinaryTypeValidation) {
            MetaValidationBinaryType instance = new MetaValidationBinaryType();
            instance.applyConfig((BinaryTypeValidation)def);
            return instance;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        this.beanValidation = config.getValue("beanValidation", BeanValidationConfig.class);
        if (this.beanValidation != null) {
            this.validator = this.beanValidation.getValidatorFactory().getValidator();
        }
    }
}

