/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.transaction;

import org.iplass.mtp.transaction.Holder;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionStatus;

final class NoTransaction
implements Transaction {
    NoTransaction() {
    }

    @Override
    public void commit() {
        Holder.logger.warn("there is no transaction, so can not commit.");
    }

    @Override
    public void rollback() {
        Holder.logger.warn("there is no transaction, so can not rollback.");
    }

    @Override
    public void setRollbackOnly() {
        Holder.logger.warn("there is no transaction, so can not set rollbackOnly.");
    }

    @Override
    public boolean isRollbackOnly() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public TransactionStatus getStatus() {
        return TransactionStatus.NONE;
    }

    @Override
    public void setAttribute(Object key, Object value) {
        Holder.logger.warn("there is no transaction, so can not set attribute:key=" + key + ", value=" + value);
    }

    @Override
    public Object getAttribute(Object key) {
        return null;
    }

    @Override
    public Object removeAttribute(Object key) {
        Holder.logger.warn("there is no transaction, so can not remove attribute:key=" + key);
        return null;
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        Holder.logger.warn("there is no transaction, so can not add TransactionListener:" + listener);
    }

    public boolean equals(Object obj) {
        return obj instanceof NoTransaction;
    }

    public int hashCode() {
        return NoTransaction.class.getName().hashCode();
    }
}

