DROP TABLE "T_TENANT" CASCADE CONSTRAINT;
CREATE TABLE "T_TENANT" 
(
    "ID" NUMBER(7,0) NOT NULL ENABLE, 
    "NAME" VARCHAR2(256 BYTE) NOT NULL ENABLE, 
    "DESCRIPTION" VARCHAR2(4000 BYTE), 
    "HOST_NAME" VARCHAR2(256 BYTE), 
    "URL" VARCHAR2(256 BYTE) NOT NULL ENABLE, 
    "YUKO_DATE_FROM" DATE NOT NULL ENABLE, 
    "YUKO_DATE_TO" DATE NOT NULL ENABLE, 
    "CRE_USER" VARCHAR2(64 BYTE), 
    "CRE_DATE" TIMESTAMP (3), 
    "UP_USER" VARCHAR2(64 BYTE), 
    "UP_DATE" TIMESTAMP (3), 
     CONSTRAINT "T_TENANT_PK" PRIMARY KEY ("URL")
);

CREATE INDEX "T_TENANT_INDEX1" ON "T_TENANT" ("ID");

DROP SEQUENCE SEQ_T_TENANT_ID;
CREATE SEQUENCE SEQ_T_TENANT_ID MINVALUE 1 MAXVALUE 9999999 INCREMENT BY 1 START WITH 1 NOCACHE NOORDER NOCYCLE;

CREATE OR REPLACE TRIGGER "TRIG_T_TENANT" 
BEFORE INSERT ON T_TENANT
FOR EACH ROW
DECLARE
BEGIN
    IF (:NEW.ID IS NULL) THEN
      SELECT SEQ_T_TENANT_ID.NEXTVAL INTO :NEW.ID FROM DUAL;
    END IF;

END;
/

ALTER TRIGGER "TRIG_T_TENANT" ENABLE;
