/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.definition.binary;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.iplass.mtp.definition.binary.BinaryDefinition;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaDataService;
import org.iplass.mtp.spi.ServiceRegistry;

public class FileBinaryDefinition
implements BinaryDefinition {
    private static final long serialVersionUID = -4061392972792605539L;
    transient Path file;
    private transient boolean isTemp;
    private long size;
    private String name;

    public FileBinaryDefinition() {
        this.isTemp = false;
    }

    public FileBinaryDefinition(String name, Path file) {
        this.name = name;
        this.file = file;
        this.isTemp = false;
        try {
            this.size = Files.size(file);
        }
        catch (IOException e) {
            throw new IllegalStateException("can't get file size: " + file, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("can't open file: " + this.file, e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isTemp) {
            Files.deleteIfExists(this.file);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        long size = this.getSize();
        out.writeLong(size);
        try (InputStream is = this.getInputStream();){
            byte[] buff = new byte[8192];
            long count = 0L;
            int n = 0;
            while (-1 != (n = is.read(buff))) {
                out.write(buff, 0, n);
                count += (long)n;
            }
            if (size != count) {
                throw new IOException("unmatch size:" + size + " != InputStream length:" + count);
            }
        }
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        BinaryMetaDataService service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);
        this.name = in.readUTF();
        this.size = in.readLong();
        Path tempDir = service.getTempFileDir();
        this.file = Files.createTempFile(tempDir, "fbd_", ".tmp", new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(this.file, new OpenOption[0]);){
            int ren;
            byte[] buff = new byte[8192];
            for (long remain = this.size; remain > 0L; remain -= (long)ren) {
                ren = remain >= (long)buff.length ? in.read(buff) : in.read(buff, 0, (int)remain);
                if (ren < 0) {
                    throw new EOFException("cant read data correctly");
                }
                os.write(buff, 0, ren);
            }
        }
        this.isTemp = true;
    }
}

