/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.query.QueryServiceHolder;
import org.iplass.mtp.impl.query.WhereSyntax;

public class UpdateCondition {
    private List<UpdateValue> values;
    private String definitionName;
    private Where where;
    private boolean lockStrictly = false;
    private boolean checkUpdatable = true;

    public UpdateCondition() {
    }

    public UpdateCondition(String definitionName) {
        this.definitionName = definitionName;
    }

    public UpdateCondition(String definitionName, List<UpdateValue> values, Where where) {
        this.definitionName = definitionName;
        this.values = values;
        this.where = where;
    }

    public boolean isCheckUpdatable() {
        return this.checkUpdatable;
    }

    public void setCheckUpdatable(boolean checkUpdatable) {
        this.checkUpdatable = checkUpdatable;
    }

    public UpdateCondition value(String entityField, Object value) {
        if (this.values == null) {
            this.values = new ArrayList<UpdateValue>();
        }
        this.values.add(new UpdateValue(entityField, value));
        return this;
    }

    public UpdateCondition value(String entityField, ValueExpression value) {
        if (this.values == null) {
            this.values = new ArrayList<UpdateValue>();
        }
        this.values.add(new UpdateValue(entityField, value));
        return this;
    }

    public Where where() {
        if (this.where == null) {
            this.where = new Where();
        }
        return this.where;
    }

    public UpdateCondition where(String whereClause) {
        String whereStr = "WHERE " + whereClause;
        try {
            this.where = (Where)QueryServiceHolder.getInstance().getQueryParser().parse(whereStr, WhereSyntax.class);
        }
        catch (ParseException e) {
            throw new QueryException(e.getMessage(), e);
        }
        return this;
    }

    public UpdateCondition lockStrictly() {
        this.lockStrictly = true;
        return this;
    }

    public UpdateCondition nocheckUpdatable() {
        this.checkUpdatable = false;
        return this;
    }

    public UpdateCondition where(Condition whereCondition) {
        this.where = new Where(whereCondition);
        return this;
    }

    public List<UpdateValue> getValues() {
        return this.values;
    }

    public void setValues(List<UpdateValue> values) {
        this.values = values;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public Where getWhere() {
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public boolean isLockStrictly() {
        return this.lockStrictly;
    }

    public void setLockStrictly(boolean lockStrictly) {
        this.lockStrictly = lockStrictly;
    }

    public UpdateCondition copy() {
        UpdateCondition copy = new UpdateCondition();
        if (this.values != null) {
            copy.values = new ArrayList<UpdateValue>(this.values.size());
            for (UpdateValue uv : this.values) {
                copy.values.add(uv.copy());
            }
        }
        copy.definitionName = this.definitionName;
        if (this.where != null) {
            copy.where = (Where)this.where.copy();
        }
        copy.lockStrictly = this.lockStrictly;
        copy.checkUpdatable = this.checkUpdatable;
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(this.definitionName);
        sb.append(" set ");
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                UpdateValue uv = this.values.get(i);
                sb.append(uv.entityField).append("=").append(uv.value);
            }
        }
        if (this.where != null) {
            sb.append(" ").append(this.where);
        }
        return sb.toString();
    }

    public static class UpdateValue {
        private String entityField;
        private ValueExpression value;

        public UpdateValue() {
        }

        public UpdateValue(String entityField, Object value) {
            this.entityField = entityField;
            this.value = value instanceof ValueExpression ? (ValueExpression)value : new Literal(value);
        }

        public UpdateValue(String entityField, ValueExpression value) {
            this.entityField = entityField;
            this.value = value;
        }

        public String getEntityField() {
            return this.entityField;
        }

        public void setEntityField(String entityField) {
            this.entityField = entityField;
        }

        public ValueExpression getValue() {
            return this.value;
        }

        public void setValue(ValueExpression value) {
            this.value = value;
        }

        public UpdateValue copy() {
            UpdateValue copy = new UpdateValue();
            copy.entityField = this.entityField;
            if (this.value != null) {
                copy.value = (ValueExpression)this.value.copy();
            }
            return copy;
        }
    }
}

