/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.permission;

import java.util.function.Supplier;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.iplass.mtp.impl.entity.auth.EntityQueryAuthContextHolder;

public class EntityPermission
extends Permission {
    private final String definitionName;
    private final Action action;

    public static <T> T doQueryAs(Action permissionAction, Supplier<T> action) {
        return EntityPermission.doQueryAs(permissionAction, null, action);
    }

    public static <T> T doQueryAs(String[] withoutConditionReferenceName, Supplier<T> action) {
        return EntityPermission.doQueryAs(null, withoutConditionReferenceName, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doQueryAs(Action permissionAction, String[] withoutConditionReferenceName, Supplier<T> action) {
        EntityQueryAuthContextHolder.set(permissionAction, withoutConditionReferenceName);
        try {
            T t = action.get();
            return t;
        }
        finally {
            EntityQueryAuthContextHolder.clear();
        }
    }

    public static boolean isLimitedPermission(EntityPermission permission) {
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(permission);
        return eac.hasLimitCondition(permission, user);
    }

    public EntityPermission(String definitionName, Action action) {
        this.definitionName = definitionName;
        this.action = action;
    }

    public final String getDefinitionName() {
        return this.definitionName;
    }

    public final Action getAction() {
        return this.action;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.definitionName == null ? 0 : this.definitionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPermission other = (EntityPermission)obj;
        if (this.action != other.action) {
            return false;
        }
        return !(this.definitionName == null ? other.definitionName != null : !this.definitionName.equals(other.definitionName));
    }

    public String toString() {
        return "EntityPermission [definitionName=" + this.definitionName + ", action=" + (Object)((Object)this.action) + "]";
    }

    public static enum Action {
        REFERENCE,
        CREATE,
        UPDATE,
        DELETE;

    }
}

