/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitor;

public class From
implements ASTNode {
    private static final long serialVersionUID = 7328311094744595840L;
    private String entityName;
    private AsOf asOf;

    public From() {
    }

    public From(String entityName) {
        this.entityName = entityName;
        this.checkValidEntityName();
    }

    private void checkValidEntityName() {
        if (this.entityName != null && this.entityName.length() > 0) {
            char c = this.entityName.charAt(0);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
                throw new QueryException(this.entityName + " is not valid EntityName.");
            }
            for (int i = 1; i < this.entityName.length(); ++i) {
                c = this.entityName.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_' || c == ':') continue;
                throw new QueryException(this.entityName + " is not valid EntityName.");
            }
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
        this.checkValidEntityName();
    }

    public AsOf getAsOf() {
        return this.asOf;
    }

    public void setAsOf(AsOf asOf) {
        this.asOf = asOf;
    }

    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.asOf == null) {
            return "from " + this.entityName;
        }
        return "from " + this.entityName + " " + this.asOf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.asOf == null ? 0 : this.asOf.hashCode());
        result = 31 * result + (this.entityName == null ? 0 : this.entityName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        From other = (From)obj;
        if (this.asOf == null ? other.asOf != null : !this.asOf.equals(other.asOf)) {
            return false;
        }
        return !(this.entityName == null ? other.entityName != null : !this.entityName.equals(other.entityName));
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }
}

