/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.condition.expr;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;

public class Or
extends Condition {
    private static final long serialVersionUID = -7950847141304557913L;
    private List<Condition> childExpressions;

    public Or() {
    }

    public Or(Condition ... condition) {
        if (condition != null) {
            ArrayList<Condition> condList = new ArrayList<Condition>();
            for (Condition c : condition) {
                condList.add(c);
            }
            this.childExpressions = condList;
        }
    }

    public Or(List<Condition> childExpressions) {
        this.childExpressions = childExpressions;
    }

    public void setConditions(List<Condition> conditions) {
        this.childExpressions = conditions;
    }

    public void addExpression(Condition expression) {
        if (this.childExpressions == null) {
            this.childExpressions = new ArrayList<Condition>();
        }
        this.childExpressions.add(expression);
    }

    public List<Condition> getChildExpressions() {
        return this.childExpressions;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childExpressions == null ? 0 : this.childExpressions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Or other = (Or)obj;
        return !(this.childExpressions == null ? other.childExpressions != null : !this.childExpressions.equals(other.childExpressions));
    }

    @Override
    public String toString() {
        if (this.childExpressions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.childExpressions.size(); ++i) {
                if (i != 0) {
                    sb.append(" or ");
                }
                sb.append(this.childExpressions.get(i).toString());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public void accept(ConditionVisitor visitor) {
        if (visitor.visit(this) && this.childExpressions != null) {
            for (Condition exp : this.childExpressions) {
                exp.accept(visitor);
            }
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public Condition strip() {
        if (this.childExpressions != null && this.childExpressions.size() == 1) {
            return this.childExpressions.get(0);
        }
        return this;
    }

    public Or or(Condition expression) {
        this.addExpression(expression);
        return this;
    }

    public Or eq(String propName, Object value) {
        Equals eq = new Equals(propName, value);
        this.addExpression(eq);
        return this;
    }

    public Or neq(String propName, Object value) {
        NotEquals eq = new NotEquals(propName, value);
        this.addExpression(eq);
        return this;
    }

    public Or lt(String propName, Object value) {
        Lesser less = new Lesser(propName, value);
        this.addExpression(less);
        return this;
    }

    public Or lte(String propName, Object value) {
        LesserEqual lessEq = new LesserEqual(propName, value);
        this.addExpression(lessEq);
        return this;
    }

    public Or gt(String propName, Object value) {
        Greater great = new Greater(propName, value);
        this.addExpression(great);
        return this;
    }

    public Or gte(String propName, Object value) {
        GreaterEqual greatEq = new GreaterEqual(propName, value);
        this.addExpression(greatEq);
        return this;
    }

    public Or in(String propName, Object ... values) {
        In in = new In(propName, values);
        this.addExpression(in);
        return this;
    }

    public Or in(String propName, SubQuery subQuery) {
        In in = new In(propName, subQuery);
        this.addExpression(in);
        return this;
    }

    @Deprecated
    public Or like(String propName, String pattern) {
        Like like = new Like(propName, pattern);
        this.addExpression(like);
        return this;
    }

    public Or like(String propName, String str, Like.MatchPattern matchPatternType) {
        Like like = new Like(propName, str, matchPatternType);
        this.addExpression(like);
        return this;
    }

    public Or between(String propName, Object from, Object to) {
        Between bet = new Between(propName, from, to);
        this.addExpression(bet);
        return this;
    }

    public Or isNull(String propName) {
        IsNull isNull = new IsNull(propName);
        this.addExpression(isNull);
        return this;
    }

    public Or isNotNull(String propName) {
        IsNotNull isNotNull = new IsNotNull(propName);
        this.addExpression(isNotNull);
        return this;
    }

    public Or contains(String fullTextSearchExpression) {
        Contains contains = new Contains(fullTextSearchExpression);
        this.addExpression(contains);
        return this;
    }
}

