/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.condition.predicate;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;

public class Between
extends Predicate {
    private static final long serialVersionUID = 6957341207431475353L;
    private ValueExpression from;
    private ValueExpression to;
    private ValueExpression property;

    public Between() {
    }

    public Between(String propertyName, Object fromLiteral, Object toLiteral) {
        this.setPropertyName(propertyName);
        this.from = fromLiteral instanceof ValueExpression ? (ValueExpression)fromLiteral : new Literal(fromLiteral);
        this.to = toLiteral instanceof ValueExpression ? (ValueExpression)toLiteral : new Literal(toLiteral);
    }

    public Between(String propertyName, ValueExpression from, ValueExpression to) {
        this.setPropertyName(propertyName);
        this.from = from;
        this.to = to;
    }

    public Between(ValueExpression property, ValueExpression from, ValueExpression to) {
        this.setProperty(property);
        this.from = from;
        this.to = to;
    }

    public String getPropertyName() {
        if (this.property == null) {
            return null;
        }
        return this.property.toString();
    }

    public void setPropertyName(String propertyName) {
        this.property = new EntityField(propertyName);
    }

    public void setProperty(ValueExpression property) {
        this.property = property;
    }

    public ValueExpression getProperty() {
        return this.property;
    }

    public ValueExpression getFrom() {
        return this.from;
    }

    public void setFrom(ValueExpression from) {
        this.from = from;
    }

    public ValueExpression getTo() {
        return this.to;
    }

    public void setTo(ValueExpression to) {
        this.to = to;
    }

    @Override
    public void accept(ConditionVisitor visitor) {
        if (visitor.visit(this) && visitor instanceof ValueExpressionVisitor) {
            if (this.property != null) {
                this.property.accept((ValueExpressionVisitor)((Object)visitor));
            }
            if (this.from != null) {
                this.from.accept((ValueExpressionVisitor)((Object)visitor));
            }
            if (this.to != null) {
                this.to.accept((ValueExpressionVisitor)((Object)visitor));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPropertyName()).append(" between ").append(this.from).append(" and ").append(this.to);
        return sb.toString();
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Between other = (Between)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }
}

