/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.condition.predicate;

import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;

public abstract class ComparisonPredicate
extends Predicate {
    private static final long serialVersionUID = 2764393184976029446L;
    private ValueExpression property;
    private ValueExpression value;

    public ComparisonPredicate() {
    }

    public ComparisonPredicate(String propertyName, Object valueLiteral) {
        this.setPropertyName(propertyName);
        if (valueLiteral instanceof ValueExpression) {
            this.setValue((ValueExpression)valueLiteral);
        } else {
            this.setValue(new Literal(valueLiteral));
        }
    }

    public ComparisonPredicate(ValueExpression property, ValueExpression value) {
        this.setProperty(property);
        this.setValue(value);
    }

    public String getPropertyName() {
        if (this.property == null) {
            return null;
        }
        return this.property.toString();
    }

    public void setPropertyName(String propertyName) {
        this.property = new EntityField(propertyName);
    }

    public void setProperty(ValueExpression property) {
        this.property = property;
    }

    public ValueExpression getProperty() {
        return this.property;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPropertyName()).append(this.getOpString()).append(this.value);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getOpString() == null ? 0 : this.getOpString().hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparisonPredicate other = (ComparisonPredicate)obj;
        if (this.getOpString() == null ? other.getOpString() != null : !this.getOpString().equals(other.getOpString())) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    protected abstract String getOpString();
}

