/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.condition.predicate;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.condition.predicate.Predicate;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.util.StringUtil;

public class Like
extends Predicate {
    private static final long serialVersionUID = 5430090669405885205L;
    public static final String US = "_";
    public static final String PS = "%";
    public static final String ES = "\\";
    private Literal pattern;
    private ValueExpression property;
    private CaseType caseType = CaseType.CI;

    public Like() {
    }

    @Deprecated
    public Like(String propertyName, String pattern) {
        this(propertyName, pattern, CaseType.CI);
    }

    @Deprecated
    public Like(String propertyName, String pattern, CaseType caseType) {
        this.setPropertyName(propertyName);
        this.pattern = new Literal(pattern);
        this.caseType = caseType;
    }

    @Deprecated
    public Like(String propertyName, Literal pattern, CaseType caseType) {
        this.setPropertyName(propertyName);
        this.pattern = pattern;
        this.caseType = caseType;
    }

    public Like(String property, String str, MatchPattern matchPattern) {
        this(property, str, matchPattern, CaseType.CI);
    }

    public Like(ValueExpression property, String str, MatchPattern matchPattern) {
        this(property, str, matchPattern, CaseType.CI);
    }

    public Like(String property, String str, MatchPattern matchPattern, CaseType caseType) {
        this(property, str, matchPattern, caseType, true);
    }

    public Like(String property, String str, MatchPattern matchPattern, CaseType caseType, boolean asBindVariable) {
        this.setPropertyName(property);
        StringBuilder sb = new StringBuilder();
        if (matchPattern == MatchPattern.POSTFIX || matchPattern == MatchPattern.PARTIAL) {
            sb.append(PS);
        }
        sb.append(StringUtil.escapeEqlForLike(str));
        if (matchPattern == MatchPattern.PREFIX || matchPattern == MatchPattern.PARTIAL) {
            sb.append(PS);
        }
        this.pattern = new Literal(sb.toString(), asBindVariable);
        this.caseType = caseType;
    }

    @Deprecated
    public Like(ValueExpression property, String pattern) {
        this(property, pattern, CaseType.CI);
    }

    @Deprecated
    public Like(ValueExpression property, String pattern, CaseType caseType) {
        this.setProperty(property);
        this.pattern = new Literal(pattern);
        this.caseType = caseType;
    }

    public Like(ValueExpression property, Literal pattern, CaseType caseType) {
        this.setProperty(property);
        this.pattern = pattern;
        this.caseType = caseType;
    }

    public Like(ValueExpression property, String str, MatchPattern matchPattern, CaseType caseType) {
        this(property, str, matchPattern, caseType, false);
    }

    public Like(ValueExpression property, String str, MatchPattern matchPattern, CaseType caseType, boolean asBindVariable) {
        this.setProperty(property);
        StringBuilder sb = new StringBuilder();
        if (matchPattern == MatchPattern.POSTFIX || matchPattern == MatchPattern.PARTIAL) {
            sb.append(PS);
        }
        sb.append(StringUtil.escapeEqlForLike(str));
        if (matchPattern == MatchPattern.PREFIX || matchPattern == MatchPattern.PARTIAL) {
            sb.append(PS);
        }
        this.pattern = new Literal(sb.toString(), asBindVariable);
        this.caseType = caseType;
    }

    public CaseType getCaseType() {
        return this.caseType;
    }

    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public String getPropertyName() {
        if (this.property == null) {
            return null;
        }
        return this.property.toString();
    }

    public void setPropertyName(String propertyName) {
        this.property = new EntityField(propertyName);
    }

    public void setProperty(ValueExpression property) {
        this.property = property;
    }

    public ValueExpression getProperty() {
        return this.property;
    }

    public String getPattern() {
        if (this.pattern == null) {
            return null;
        }
        return (String)this.pattern.getValue();
    }

    public void setPattern(String pattern) {
        this.pattern = new Literal(pattern);
    }

    public Literal getPatternAsLiteral() {
        return this.pattern;
    }

    public void setPatternAsLiteral(Literal pattern) {
        this.pattern = pattern;
    }

    @Override
    public void accept(ConditionVisitor visitor) {
        if (visitor.visit(this) && visitor instanceof ValueExpressionVisitor && this.getProperty() != null) {
            this.getProperty().accept((ValueExpressionVisitor)((Object)visitor));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPropertyName()).append(" like ");
        if (this.pattern == null) {
            sb.append("null");
        } else {
            sb.append(this.pattern.toString());
        }
        if (this.caseType != null && this.caseType == CaseType.CS) {
            sb.append(" cs");
        }
        return sb.toString();
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseType == null ? 0 : this.caseType.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Like other = (Like)obj;
        if (this.caseType != other.caseType) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public static enum CaseType {
        CI,
        CS;

    }

    public static enum MatchPattern {
        PREFIX,
        POSTFIX,
        PARTIAL;

    }
}

