/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.hint;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.hint.EQLHint;
import org.iplass.mtp.entity.query.hint.HintVisitor;

public class CacheHint
extends EQLHint {
    private static final long serialVersionUID = -2368342891687154508L;
    private CacheScope scope = CacheScope.GLOBAL;
    private int ttl;

    public CacheHint() {
    }

    public CacheHint(CacheScope scope) {
        this.scope = scope;
    }

    public CacheHint(CacheScope scope, int ttl) {
        this.scope = scope;
        this.ttl = ttl;
    }

    public CacheScope getScope() {
        return this.scope;
    }

    public void setScope(CacheScope scope) {
        this.scope = scope;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public void accept(HintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + this.ttl;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheHint other = (CacheHint)obj;
        if (this.scope != other.scope) {
            return false;
        }
        return this.ttl == other.ttl;
    }

    @Override
    public String toString() {
        if (this.scope != null) {
            switch (this.scope) {
                case TRANSACTION: {
                    return "cache(transaction)";
                }
                case GLOBAL: {
                    if (this.ttl > 0) {
                        return "cache(" + this.ttl + ")";
                    }
                    return "cache";
                }
                case GLOBAL_KEEP: {
                    if (this.ttl > 0) {
                        return "cache(keep, " + this.ttl + ")";
                    }
                    return "cache(keep)";
                }
                case GLOBAL_RELOAD: {
                    if (this.ttl > 0) {
                        return "cache(reload, " + this.ttl + ")";
                    }
                    return "cache(reload)";
                }
            }
        }
        return "cache";
    }

    public static enum CacheScope {
        TRANSACTION,
        GLOBAL,
        GLOBAL_KEEP,
        GLOBAL_RELOAD;

    }
}

